{ stdenv, libzip }:
stdenv.mkDerivation {
  name = "jndinonono";
  src = ./src;
  buildInputs = [ (libzip.overrideAttrs (oA: { cmakeFlags = (oA.cmakeFlags or []) ++ [ "-DBUILD_SHARED_LIBS:BOOL=OFF" ]; })) ];
  buildPhase = ''
    ${stdenv.cc}/bin/cc -D_GNU_SOURCE client.c -o jndi-no-no-no
    ${stdenv.cc}/bin/cc -D_GNU_SOURCE -shared -o preload.so -FPIC preload.c -ldl -lzip
  '';
  installPhase = ''
    install -D jndi-no-no-no $out/bin/jndi-no-no-no
    install -D preload.so $out/share/preload.so
  '';
}
