{ stdenv, lib, kernel, buildPackages }:

stdenv.mkDerivation rec {
  pname = "global_execve_interceptor";
  version = "0.0.1";

  src = lib.cleanSource ./src;

  hardeningDisable = [ "pic" ];

  nativeBuildInputs = kernel.moduleBuildDependencies;

  makeFlags = [
    # For the module's own makefile
    "KDIR=${kernel.dev}/lib/modules/${kernel.modDirVersion}/build"

    # To be passed through to the linux's makefile. See manual-config.nix
    "CC=${stdenv.cc}/bin/${stdenv.cc.targetPrefix}cc"
    "HOSTCC=${buildPackages.stdenv.cc}/bin/${buildPackages.stdenv.cc.targetPrefix}cc"
    "ARCH=${stdenv.hostPlatform.linuxArch}"
    "CROSS_COMPILE=${stdenv.cc.targetPrefix}"
  ];

  NIX_CFLAGS_COMPILE_MARCH = " ";
  NIX_CFLAGS_COMPILE_MCPU = " ";
  NIX_CFLAGS_COMPILE_MFPU = " ";
  NIX_CFLAGS_COMPILE_MFLOAT_ABI = " ";

  outputs = [ "out" "dev" ];

  installPhase = ''
    install -D global_execve_interceptor.ko $out/lib/modules/${kernel.modDirVersion}/misc/global_execve_interceptor.ko
  '';
}
