(in-package "ACL2")

#|

This is the weak defun-sk macro.  I only thought about existential
quantification.  Do a macro-expansion to see what it produces, but
essentially it produces a function with only one constraint: this
allows you to prove the function is non-nil if you can exhibit a
witness.  Many times that is all one needs.

|#

(defmacro defun-weak-sk (name args body &key doc quant-ok
  skolem-name thm-name rewrite)
  (let* ((exists-p (and (true-listp body)
                        (symbolp (car body))
                        (equal (symbol-name (car body)) "EXISTS")))
         (bound-vars (let ((var-lst (cadr body)))
		       (and (true-listp body)
			    (or (symbolp var-lst)
				(true-listp var-lst))
			    (cond ((atom var-lst)
				   (list var-lst))
				  (t var-lst)))))
         (body-guts (and (true-listp body) (caddr body)))
         (skolem-name
          (or skolem-name
              (intern-in-package-of-symbol
               (concatenate 'string (symbol-name name) "-WITNESS")
               name)))
	 (skolem-constraint-name
	  (intern-in-package-of-symbol
	   (concatenate 'string (symbol-name skolem-name) "-CONSTRAINT")
	   skolem-name))
         (thm-name
          (or thm-name
              (intern-in-package-of-symbol
               (concatenate 'string (symbol-name name)
                            (if exists-p "-SUFF" "-NECC"))
               name)))
         (msg (non-acceptable-defun-sk-p name args body doc
  quant-ok rewrite exists-p)))
    (if msg
        `(er soft '(defun-sk . ,name)
             "~@0"
             ',msg)
      `(encapsulate
	((,name ,args ,(if (= (length bound-vars) 1)
			   (car bound-vars)
			 (cons 'mv bound-vars))))
	(local 
	 (encapsulate		
	  ((,skolem-name ,args
			 ,(if (= (length bound-vars) 1)
			      (car bound-vars)
			    (cons 'mv bound-vars))))
	  (local (in-theory '(implies)))
	  (local
	   (defchoose ,skolem-name ,bound-vars ,args
	     ,(if exists-p
		  body-guts
		`(not ,body-guts))))

       	; A :type-prescription lemma is needed in the case of more than one bound
   	; variable, in case we want to do guard proofs.
	  
	; PETE: I am leaving this because it comes from defun-sk, but
	; notice that it is not very useful because this theorem will
	; not exists outside the main encapsulate.  I should either
	; prove it's analogue in the surrounding encapsulate or I
	; should delete it.  This seems kind of kludgy, e.g., why not
	; prove that what you get is a true-list of the right size?
	; Perhaps I should just blow up (exists (a ... n) body) into
	; (exists (a) ... (exists (n) body) ... )?

	  ,@(cond 
	     ((null (cdr bound-vars)) nil)
	     (t
	      `((local (defthm ,(intern-in-package-of-symbol
				 (concatenate 'string (symbol-name skolem-name) "-TYPE-PRESCRIPTION")
				 skolem-name)
			 (true-listp ,(cons skolem-name args))
			 :rule-classes :type-prescription
			 :hints (("Goal" :by ,skolem-name)))))))
	  (defthm ,skolem-constraint-name
	    (implies ,body-guts
		     ,(if (= (length bound-vars) 1)
			  `(let ((,(car bound-vars) (,skolem-name ,@args)))
			     ,body-guts)
			`(mv-let (,@bound-vars)
				 (,skolem-name ,@args)
				 ,body-guts)))
	    :hints (("Goal"
		     :use ,skolem-name))
	    :rule-classes nil)))
	(local 
	 (defun ,name ,args (declare (xargs :normalize nil))
	   ,(if (= (length bound-vars) 1)
		`(let ((,(car bound-vars) (,skolem-name ,@args)))
		   ,body-guts)
	      `(mv-let (,@bound-vars)
		       (,skolem-name ,@args)
		       ,body-guts))))
	(defthm ,thm-name
	  ,(if exists-p
	       `(implies ,body-guts
			 (,name ,@args))
	     `(implies (not ,body-guts)
		       (not (,name ,@args))))
	  :hints (("Goal" 
		   :in-theory nil
		   :use ((:instance ,skolem-constraint-name)
			 (:instance ,name)))))

	; PETE: The above was added to make sure that nothing
	; interferes with the proof (e.g., function definitions and
	; rewrites).  I wanted to add the above rule as a
	; forward-chaining rule, but due to the free variable problem,
	; but since I don't want to explore body-guts (to figure out
	; what the trigger-terms should be), I can't.

	,@(if doc
	      `((defdoc ,name ,doc))
	    nil)))))

