(in-package "ACL2")

(include-book "acl2s/portcullis" :dir :system)

(defconst *export-symbols*
  (union-eq *acl2-exports*
	    (union-eq '(len true-listp acl2s::defunc defequiv defcong i-am-here
			zp defrefinement defabbrev defstub e0-ord-< 
			e0-ordinalp cdr-cons car-cons car-cdr-elim
		        booleanp booleanp-compound-recognizer commutativity-of-+
			binary-append append default-car default-cdr cons-equal
			binary-+ acl2-numberp fix nfix alistp assoc-equal
			put-assoc-equal value-of union-eq defpkg
			a b x y z alist key i j l k m list x-equiv y-equiv 
			x1 x2 x3 x4 x5 y1 y2 y3 y4 y5 z1 z2 z3 z4 z5 b*
			*export-symbols* acl2s::check= acl2s::test?)
		      *common-lisp-symbols-from-main-lisp-package*)))

(defconst *sets-symbols* *export-symbols*)

(defpkg "FLAT-SETS" *sets-symbols*)

(defconst *FULL-SETS-symbols*
  '(flat-sets::setp flat-sets::tlp flat-sets::make-binary-macro
    flat-sets::test-then-skip))
  
(defconst *FAST-SETS-symbols*
  (union-eq 
   *sets-symbols*
   (union-eq *FULL-SETS-symbols*
             '(flat-sets::=< flat-sets::=<-definition-rule
                             flat-sets::== flat-sets::==-definition-rule
                             flat-sets::in flat-sets::in-definition-rule))))

(defpkg "FAST-FLAT-SETS" *fast-sets-symbols*)

(defpkg "FULL-SETS"
  (union-eq *sets-symbols* *full-sets-symbols*))

(defpkg "SETS" (union-eq *sets-symbols* *full-sets-symbols*))
