#|

 CS 4820 Fall 2018

 Homework 4.
 Due: 10/12 (Midnight)

 For this assignment, work in groups of 2-3. Send me exactly one
 solution per team and make sure to follow the submission instructions
 on the course Web page. In particular, make sure that the subject of
 your email submission is "CS 4820 HWK 4".

 The group members are:

 ... (put the names of the group members here)

 For this homework, you will build a set library using equivalences
 and congruence-based reasoning. Relevant documentation topics include
 the following:

  :doc congruence
  :doc equivalence
  :doc defcong
  :doc defequiv

 This homework is designed to give you experience using more advanced
 aspects of ACL2, so expect to spend time trying to understand how
 things work, how to query the theorem prover when things aren't going
 as expected, how to come up with good rewrite strategies, etc. Please
 plan ahead and give yourselves plenty of time. Also, ask questions on
 Piazza.

 This homework consists of the following main files. Each file
 contains instructions. You should go through the files in the order
 given below, but only after you have read to the end of the notes in
 this file.

  1. hwk4-utilities.lisp: a file containing useful utility
     functions.  

  2. hwk4-flat-sets.lisp: in this file we develop flat set theory.

  3. hwk4-fast-flat-sets.lisp: in this file we develop more efficent
     definitions than those used in hwk4-flat-sets.lisp.

  4. hwk4.lisp: this file, the top-level file. In this file we develop
     a version of the function definitions that contain contracts.

  5. hwk4-full-sets.lisp: in this file we develop hereditarily-finite
     set theory (extra credit).

 Remember hwk4-full-sets.lisp is extra credit, so make sure you get
 1-4 working first. 

 All of the files use packages. See :doc acl2::packages. Packages
 allow us to define namespaces so that we can avoid name
 conflicts. For example, you'll notice that we define multiple
 versions of set-union: flat-sets::set-union,
 fast-flat-sets::set-union, and sets::set-union.

 We also use "include-book" forms. See :doc include-book. Books allow
 us to structure projects. We can certify a book (see :doc
 certify-book) and then include it. The certification process involves
 ACL2 admitting all the forms in the book and generating a certificate
 that allows us to load the book (via include-book) quickly. This is a
 must for proof-engineering.

 You can certify all the books by using the cert.pl utility, which is
 in the following directory, where ACL2S-DIR is where you installed ACL2s
  
 ACL2S-DIR/Contents/Eclipse/plugins/acl2_image.macosx.x86_64_8.0.0/books/build/

 We'll use BOOKS to refer to the directory 

 ACL2S-DIR/Contents/Eclipse/plugins/acl2_image.macosx.x86_64_8.0.0/books/

 and we'll use ACL2-DIR to refer to the directory

 ACL2S-DIR/Contents/Eclipse/plugins/acl2_image.macosx.x86_64_8.0.0/

 First, make sure that your acl2s books are properly certified.  Start
 by making sure that all of the .pl files in the build directory have
 execute permissions. Then make sure that all the books in the
 distribution are certified with the following command in directory
 BOOKS/acl2s/.

 ../build/cert.pl --acl2 ../../run_acl2 *.lisp

 In Windows, use this instead:

 ../build/cert.pl --acl2 ../../saved_acl2.bat *.l*sp

 I'll use run_acl2 below, but Windows users should use saved_acl2.bat.

 If this does any certification, then you can kill it and run the
 following commands

 ../build/cert.pl --acl2 ../../run_acl2 -c *.lisp ../xdoc/*.lisp ../system/*.lisp ../system/doc/*.lisp
 ../build/cert.pl --acl2 ../../run_acl2 *.lisp

 If you notice certification failures, keep re-running

 ../build/cert.pl --acl2 ../../run_acl2 *.lisp

 until done.  You will then have to re-create the acl2s executable, as
 per homework 1 instructions (if you had to recertify).

 Now, let acl2s below be the acl2s image you created from homework 1.

 Normally, cert.pl will use the ACL2 image, but we want to use the
 ACL2s image, so that's why we have a file cert.image that refers to
 the acl2s image you created. In order for this to work, you can
 either change the file so that it points to your image, or you can
 leave the file as is and create an alias, acl2s, that points to the
 acl2s image you created from homework 1. You can add an alias in your
 .bashrc file (if you use bash; otherwise you'll have to update the
 file appropriate for your shell). Here's mine (the executable I
 created is ~/bin/acl2s):

 alias acl2s=~/bin/acl2s

 In the directory where the hwk files reside issue the following command
 (in a terminal):

 BOOKS/build/cert.pl --acl2 ACL2-DIR/run_acl2 *.lisp

 Try this first and make sure it works. 
 
 5pts: 
 Replace ___ with an X indicating this worked for you: ___

 Here is what is going on. The cert.pl utility uses the following files

 cert.acl2: this file includes certain directives, e.g., it allows
 skip-proofs, which is why the command above works even though you
 have not proved any of the theorems yet. Every time you update one of
 the files, you can re-run the command to make sure everything is in
 order. 

 Another file used in the build process is package.lsp. Take a look.
 It includes the package definitions. When you use the emacs version
 of ACL2S and in order to load the files for this homework, you first
 have to load package.lsp and some other stuff, which you can do with
 the following command.

 (ld "portcullis.acl2")

 Why do we have all these files?

 Well, hwk4-flat-sets.lisp is a file that contains the simplest
 definitions we can think of and all the results we want to
 prove. Since we want to use congruence-based reasoning, we need to
 define functions that work on anything.

 Then, hwk4-fast-flat-sets.lisp is a file that contains more efficient
 versions of the functions in hwk4-flat-sets.lisp. When we execute
 code, these are the definitions we want, but when we reason about
 functions, we want the definitions in hwk4-flat-sets.lisp, so we will
 prove program equivalence using rewrite rules that give us the best
 of both worlds. Finally, hwk4.lisp, this file, contains a version of
 the functions with the input contracts we really want. The reason for
 contracts is that it allows users of our library to get static
 information when they try to use the functions on arguments outside
 of their intended domain, e.g., when they try to take the set-union
 of numbers.

 Here's what to do next.

 Go through the files hwk4-flat-sets and hwk4-fast-flat-sets.

 Then go through this file.

 Then, for extra credit, go through hwk4-full-sets.

 Submit a gzipped tarball (use tar and gzip) of your solutions, but
 without the certification files. You can remove the certification
 stuff with the following commands

 BOOKS/build/cert.pl -c *.lisp
 rm Makefile-tmp
 rm *~

 So, run these commands first, then create the gzipped tarball and
 email it to me.

|#

(in-package "SETS")
(include-book "hwk4-utilities")
(include-book "hwk4-flat-sets")
(include-book "hwk4-fast-flat-sets")
(include-book "hwk4-full-sets")

(acl2s::disable-acl2s-random-testing)
(acl2s::enable-acl2s-random-testing)

#|

 We want defunc versions of the functions so that we can catch
 programming errors using contract checking. The defthms are here just
 to show that the library we developed can be used to reason about the
 functions in this file without us having to do anything.

|#

(defunc in (a X)
  "Checks for set containment, i.e., is a in X?"
  :input-contract (setp X)
  :output-contract (booleanp (in a X))
  (flat-sets::in a X))

(defunc =< (X Y)
  "Subset, i.e., X =< Y"
  :input-contract (and (setp X) (setp Y))
  :output-contract (booleanp (=< X Y))
  (flat-sets::=< X Y))
  
(defunc == (X Y)
  "Set equality, i.e., X == Y"
  :input-contract (and (setp X) (setp Y))
  :output-contract (booleanp (== X Y))
  (flat-sets::== X Y))

(defunc no-dups (X)
  :input-contract (setp X)
  :output-contract (booleanp (no-dups X))
  (fast-flat-sets::no-dups X))

(defunc add (x Y)
  :input-contract (setp Y)
  :output-contract (setp (add x Y))
  "Adds x to the set Y"
  (fast-flat-sets::add x Y))
  
(defthm add-no-dups
  (implies (and (setp Y)
                (no-dups Y))
           (no-dups (add x Y))))

(defunc set-union (X Y)
  :input-contract (and (setp X) (setp Y))
  :output-contract (setp (set-union X Y))
  (fast-flat-sets::set-union X Y))

(defthm set-union-no-dups
  (implies (and (setp X) (setp Y) (no-dups Y))
           (no-dups (set-union X Y))))

(defunc intersect (X Y)
  :input-contract (and (setp X) (setp Y))
  :output-contract (setp (intersect X Y))
  (fast-flat-sets::intersect X Y))

(defthm intersect-no-dups
  (implies (and (setp X) (setp Y))
           (no-dups (intersect X Y))))

(defthm |X =< X|
  (implies (setp X)
           (=< X X)))

(defthm |X == X|
  (implies (setp X)
           (== X X)))

(defthm |X == Y => Y == X|
  (implies (and (setp X)
                (setp Y))
           (equal (== X Y)
                  (== Y X))))

(defthm |X =< Y & Y =< Z  =>  X =< Z|
  (implies (and (setp X)
                (setp Y)
                (setp Z)
                (=< X Y)
                (=< Y Z))
           (=< X Z)))

(defthm |X == Y & Y == Z  =>  X == Z|
  (implies (and (setp X)
                (setp Y)
                (setp Z)
                (== X Y)
                (== Y Z))
           (== X Z)))

(defthm |X u X == X| 
  (implies (setp X)
           (== (set-union X X) X)))

(defthm |X u Y == Y u X| 
  (implies (and (setp X)
                (setp Y))
           (== (set-union X Y)
               (set-union Y X))))

(defthm |(X u Y) u Z == X u (Y u Z)| 
  (implies (and (setp X)
                (setp Y)
                (setp Z))
           (== (set-union (set-union X Y) Z)
               (set-union X (set-union Y Z)))))

(defthm |X & X == X| 
  (implies (setp X)
           (== (intersect X X) X)))

(defthm |X & Y  == Y & X| 
  (implies (and (setp X)
                (setp Y))
           (== (intersect X Y)
               (intersect Y X))))

(defthm |(X & Y) & Z == X & (Y & Z)| 
  (implies (and (setp X)
                (setp Y)
                (setp Z))
           (== (intersect (intersect X Y) Z)
               (intersect X (intersect Y Z)))))

(defthm |X U (Y & Z) == (X U Y) & (X U Z)| 
  (implies (and (setp X)
                (setp Y)
                (setp Z))
           (== (intersect (set-union X Y) (set-union X Z))
               (set-union X (intersect Y Z)))))

(defthm |X & (Y U Z) == (X & Y) U (X & Z)| 
  (implies (and (setp X)
                (setp Y)
                (setp Z))
           (== (set-union (intersect X Y) (intersect X Z))
               (intersect X (set-union Y Z)))))
