#|

 CS 4820 Fall 2018

 Homework 4 file. 

 This file contains useful utility functions.

 We have seen all but test-then-skip. All you should do is read the
 documentation below to understand what the macro does. Examples
 appear in hwk4-flat-sets. 

 Notice that the macro allows us is the ACL2s version of
 skip-proofs. See :doc skip-proofs. Instead of just skipping proofs,
 it also tests them and aborts if it finds a counterexample.

|#

(in-package "FLAT-SETS")

;; Define tlp and add to macro aliases table.
(defmacro tlp (x) `(true-listp ,x))
(add-macro-fn tlp true-listp)

;; A macro to generate an n-ary macro corresponding to a binary
;; function and add it to the macro aliases table.
(defmacro make-binary-macro (bin-fun macro id)
  `(progn
     (defmacro ,macro (&rest rst)
       (cond ((null rst) ,id)
             ((null (cdr rst)) (car rst))
             (t (xxxjoin ',bin-fun rst))))
     (add-macro-fn ,macro ,bin-fun)))

;; A macro that is similar to skip-proofs, except that we first
;; perform testing. Supports defthm, defcong, defequiv and
;; defrefinement.
(defmacro test-then-skip (thm)
  (declare
   (xargs :guard
          (and (tlp thm)
               (member-equal
                (car thm)
                '(acl2::defthm acl2::defcong acl2::defequiv
                  acl2::defrefinement)))))
  (if (equal (car thm) 'defthm)
      `(progn!
        (acl2s::test? ,(third thm))
        (skip-proofs ,thm))
    `(make-event
      (er-let* ((defthm (acl2::macroexpand1* ',thm 'ctx (w state) state)))
               (value `(progn! (acl2s::test? ,(second (third defthm)))
                               (skip-proofs ,',thm)))))))

(acl2s::disable-acl2s-random-testing)
