#|

CS 4820 Fall 2018

Homework 4 file.

|#

(in-package "FULL-SETS")

(include-book "hwk4-fast-flat-sets")


#|

Define in, =< and == (membership, subset and set equality) for full
sets.

In set theory the set {{1, 2}} is a set with one element, a set with
two elements: 1 and 2. This set is equivalent to {{2, 1}}.

We want to define a notion of set that faithfully captures this notion
of such sets.

Notice that what we have defined so far are flat sets, e.g., the
following holds.

|#

(check= (flat-sets::=< '((1 2)) '((2 1))) nil)

#|

The definitions you come up with have to pass the check= forms below.
These check= forms are not intended to be exhaustive.

Hint: You will have to use mutual recursion and defun. Defun is like
defunc except it does not have contracts, so define the functions as
if the input contract was t.  See the lecture notes, CAR and

 :doc mutual-recursion
 :doc defun

|#

#|
; 10pts for all three definitions

(defun in (a X) ...)
(defun =< (X Y) ...)
(defun == (X Y) ...)

(check= (in '((1 3 1 3 2)) '(((1 2)) ((3 2 2 2 1)))) t)
(check= (=< '((1 3 1 (3) 2)) '(((1 2)) (3 2 2 (3 3 3) 2 1))) t)
(check= (=< '((1 3 1 3 2)) '(((1 2)) (3 2 2 2 1 (3)))) nil)
(check= (== '((1 3 (1 3) 2)) '((1 1 2 2 3 3 (3 3 1 1))
                               (3 2 2 2 1 1 (3 1 3))))
        t)

; 10pts
(defequiv ==)
|#

#|

Define union and prove some theorems.


; 5pts
(defunc binary-set-union (X Y)
  "Set union, i.e., X U Y"
  :input-contract t
  :output-contract ...
  ...)

(make-binary-macro binary-set-union set-union nil)

; 5pts
(test-then-skip
(defthm |X u X == X| 
  (== (set-union X X) X))
)

; 5pts
(test-then-skip
(defthm |X u Y == Y u X| 
  (== (set-union X Y)
      (set-union Y X)))
)

; 5pts
(test-then-skip
(defthm |(X u Y) u Z == X u (Y u Z)| 
  (== (set-union (set-union X Y) Z)
      (set-union X (set-union Y Z))))
)
|#

