#|

 CS 4820 Fall 2018

 Homework 4 file.

 Everything up to the first (test-then-skip ...) expression is
 admitted by ACL2s and is a variant of what we did in class.

 Your job is to to admit the rest of the expressions by replacing
 expressions of the form

 (test-then-skip ...) 

 with expressions of the form

 ...

 (i.e., get rid of the test-then-skip's) and proving lemmas as
 needed. You add hints, rule-classes to defthms as you see fit.
 
 Each test-then-skip you successfully remove is worth 5pts.

|#

(in-package "FLAT-SETS")
(include-book "hwk4-utilities")
(defttag t)

;; tlp is defined in hwk4-utilities
(defmacro setp (x) `(tlp ,x))

(defunc in (a X)
  "Checks for set containment, i.e., is a in X?"
  :input-contract t
  :output-contract (booleanp (in a X))
  (cond ((atom X) nil)
        ((equal a (car X)) t)
        (t (in a (cdr X)))))

; We want to use equivalences and congruence-based reasoning, so all
; the functions we define, such as in, will be defined with an input
; contract of t. As a consequence, we can run in on improper conses.
(check= (in 3 '(1 2 3 . 4)) t)
(check= (in 4 '(1 2 3 . 4)) nil)
(check= (in '(1 2) '(1 2 3 . 4)) nil)
(check= (in '(1 2) '(1 2 3 (1 2) . 4)) t)

; We can also run in on atoms
(check= (in '(1 2) 2) nil)

(defunc =< (X Y)
  "Subset, i.e., X =< Y"
  :input-contract t
  :output-contract (booleanp (=< X Y))
  (cond ((atom X) t)
        (t (and (in (car X) Y)
                (=< (cdr X) Y)))))

; Improper cons examples.
(check= (=< '(2 . 5) '(1 2 3 . 4)) t)

(defunc == (X Y)
  "Set equality, i.e., X == Y"
  :input-contract t
  :output-contract (booleanp (== X Y))
  (and (=< X Y)
       (=< Y X)))

(defunc binary-set-union (X Y)
  "Set union, i.e., X U Y"
  :input-contract t
  :output-contract t
  (if (atom X)
      Y
    (cons (car X) (binary-set-union (cdr X) Y))))

(make-binary-macro binary-set-union set-union nil)

(defthm set-union-type
  (implies (setp Y)
           (setp (set-union X Y)))
  :rule-classes :type-prescription)

(defunc binary-intersect (X Y)
  "Set intersection, i.e., X & Y"
  :input-contract t
  :output-contract (setp (binary-intersect X Y))
  (cond ((atom X) nil)
        ((in (car X) Y)
         (cons (car X) (binary-intersect (cdr X) Y)))
        (t (binary-intersect (cdr X) Y))))

(make-binary-macro binary-intersect intersect nil)

(defthm |X =< Y => X =< {a} U Y| 
  (implies (=< X Y)
           (=< X (cons a Y))))
                
(defthm |X =< X|
  (=< X X))

(defthm |X == X|
  (== X X))

(defthm |X == Y => Y == X|
  (equal (== X Y)
         (== Y X)))

(defthm |a in X & X =< Y => a in Y|
  (implies (and (=< X Y)
                (in a X))
           (in a Y)))

(defthm |X =< Y & Y =< Z  =>  X =< Z|
  (implies (and (=< X Y)
                (=< Y Z))
           (=< X Z))
  :rule-classes ((:rewrite)
                 (:forward-chaining :trigger-terms ((=< X Y)))))

(defthm |X == Y & Y == Z  =>  X == Z|
  (implies (and (== X Y)
                (== Y Z))
           (== X Z)))

(defequiv ==)

;; This is the beginning of the test-then-skip forms.

(test-then-skip
(defthm |X u X == X| 
  (== (set-union X X) X))
)

(test-then-skip
(defcong == == (set-union X Y) 1)
)

(test-then-skip
(defcong == == (set-union X Y) 2)
)

(test-then-skip
(defthm |X u Y == Y u X| 
  (== (set-union X Y)
      (set-union Y X)))
)

(test-then-skip
(defthm |(X u Y) u Z == X u (Y u Z)| 
  (== (set-union (set-union X Y) Z)
      (set-union X (set-union Y Z))))
)

(test-then-skip
(defthm |X & X == X| 
  (== (intersect X X) X))
)

(test-then-skip
(defcong == == (intersect X Y) 1)
)

(test-then-skip
(defcong == == (intersect X Y) 2)
)

(test-then-skip
(defthm |X & Y  == Y & X| 
  (== (intersect X Y)
      (intersect Y X)))
)

(test-then-skip
(defthm |(X & Y) & Z == X & (Y & Z)| 
  (== (intersect (intersect X Y) Z)
      (intersect X (intersect Y Z))))
)

(test-then-skip
(defthm |X U (Y & Z) == (X U Y) & (X U Z)| 
  (== (intersect (set-union X Y) (set-union X Z))
      (set-union X (intersect Y Z))))
)

(test-then-skip
(defthm |X & (Y U Z) == (X & Y) U (X & Z)| 
  (== (set-union (intersect X Y) (intersect X Z))
      (intersect X (set-union Y Z))))
)
