#|

 CS 4820 Fall 2018

 Homework 4 file.

 Your job is to to use ACL2s to admit all of the expressions in this
 file by replacing expressions of the form

 (test-then-skip ...) 

 with expressions of the form

 ...

 (i.e., get rid of the test-then-skip's) and proving lemmas as
 needed. You add hints, rule-classes to defthms as you see fit.

 Each test-then-skip you successfully remove is worth 5pts.

|#

(in-package "FAST-FLAT-SETS")
(defttag t)

(include-book "hwk4-flat-sets")

(defunc no-dups (X)
  :input-contract t
  :output-contract (booleanp (no-dups X))
  (or (atom X)
      (and (not (in (car X) (cdr X)))
           (no-dups (cdr X)))))

(defunc add (x Y)
  :input-contract t
  :output-contract (consp (add x Y))
  "Adds x to the set Y"
  (if (in x Y)
      Y
    (cons x Y)))

(test-then-skip
(defthm add-type
  (implies (setp Y)
           (setp (add x Y)))
  :rule-classes :type-prescription)
)

(test-then-skip
(defthm add-no-dups
  (implies (and (setp Y)
                (no-dups Y))
           (no-dups (add x Y))))
)

(defunc set-union (X Y)
  :input-contract t
  :output-contract t
  (if (atom X)
      Y
    (set-union (cdr X) (add (car X) Y))))

(test-then-skip
(defthm set-union-type
  (implies (setp Y)
           (setp (set-union X Y)))
  :rule-classes :type-prescription)
)

(test-then-skip
(defthm set-union-no-dups
  (implies (and (setp Y) (no-dups Y))
           (no-dups (set-union X Y))))
)

(defunc intersect-aux (X Y Z)
  :input-contract (setp Z)
  :output-contract (setp (intersect-aux X Y Z))
  (cond ((atom X) Z)
        ((in (car X) Y)
         (intersect-aux (cdr X) Y (add (car X) Z)))
        (t (intersect-aux (cdr X) Y Z))))

(defunc intersect (X Y)
  :input-contract t
  :output-contract (setp (intersect X Y))
  (intersect-aux X Y nil))

(test-then-skip
(defthm intersect-no-dups
  (no-dups (intersect X Y)))
)

(test-then-skip
(defthm fast-set-union-is-set-union
  (== (set-union X Y)
      (flat-sets::set-union X Y)))
)

(test-then-skip
(defthm fast-intersect-is-set-intersect
  (== (intersect X Y)
      (flat-sets::intersect X Y)))
)

(in-theory (disable intersect intersect-definition-rule
                    == flat-sets::==-definition-rule))
