/*
 * Decompiled with CFR 0.152.
 */
package admin.utils;

import admin.utils.AdminDocumentHandler;
import admin.utils.Game;
import admin.utils.SufficientAssignment;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import gen.Accounts;
import gen.Assignment;
import gen.Buy;
import gen.Config;
import gen.Constraint;
import gen.Create;
import gen.Deliver;
import gen.Derivative;
import gen.Finish;
import gen.Pair;
import gen.PlayerID;
import gen.PlayerTransaction;
import gen.Price;
import gen.RawMaterial;
import gen.Reoffer;
import gen.Store;
import gen.Transaction;
import gen.TypeInstance;
import gen.Variable;
import utils.DerivativesFinder;
import utils.comparator.CheaperDerivativeComparator;
import utils.comparator.DerivativeComparator;
import utils.comparator.DerivativeComparatorByType;
import utils.comparator.DerivativeComparatorForList;
import utils.comparator.TransactionComparatorByTType;
import utils.comparator.TypeInstanceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleChecker {
    String message = "";
    PlayerTransaction pTrans;

    RuleChecker(PlayerTransaction playerTransaction) {
        this.pTrans = playerTransaction;
    }

    void addMessage(String string) {
        this.message = this.message + string + "\n";
    }

    public static Pair<Boolean, String> rulesFollowed(PlayerTransaction playerTransaction, Store store, Accounts accounts2, Game.GameType gameType) {
        return new RuleChecker(playerTransaction).rulesFollowed(store, accounts2, gameType);
    }

    public static Pair<Boolean, String> overtimeRulesFollowed(PlayerTransaction playerTransaction, Store store, Accounts accounts2, Game.GameType gameType) {
        return new RuleChecker(playerTransaction).overtimeRulesFollowed(store, accounts2);
    }

    public Pair<Boolean, String> rulesFollowed(Store store, Accounts accounts2, Game.GameType gameType) {
        boolean bl = this.isAccountPositive(accounts2);
        boolean bl2 = this.isBuyOrReofferRuleFollowed(store);
        boolean bl3 = this.isCreateRuleFollowed(store, gameType);
        boolean bl4 = this.isDeliveryRuleFollowed(store);
        boolean bl5 = this.isFinishRuleFollowed(store);
        return new Pair<Boolean, String>(bl && bl2 && bl3 && bl4 && bl5, this.message);
    }

    public Pair<Boolean, String> overtimeRulesFollowed(Store store, Accounts accounts2) {
        boolean bl = this.isAccountPositive(accounts2);
        boolean bl2 = this.isDeliveryRuleFollowed(store);
        boolean bl3 = this.isFinishRuleFollowed(store);
        return new Pair<Boolean, String>(bl && bl2 && bl3, this.message);
    }

    protected boolean isAccountPositive(Accounts accounts2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (Pair<PlayerID, Double> object : accounts2.accounts) {
            if (!((PlayerID)object.a).equals(this.pTrans.player.id)) continue;
            d = (Double)object.b;
        }
        for (Transaction transaction : this.pTrans.transactions) {
            if (transaction.ttype.getClass().equals(Buy.class)) {
                d2 += transaction.deriv.price.val;
            }
            if (!transaction.ttype.getClass().equals(Finish.class)) continue;
            d3 += transaction.deriv.optfinished.inner().quality.val;
        }
        if (d + d3 - d2 < 0.0) {
            this.addMessage("Negative account balance");
            return false;
        }
        return true;
    }

    protected boolean isBuyOrReofferRuleFollowed(Store store) {
        if (!this.emptyStoreBuyReoffer(store)) {
            if (!this.pTrans.transactions.contains(new TransactionComparatorByTType(new Buy())) && !this.pTrans.transactions.contains(new TransactionComparatorByTType(new Reoffer()))) {
                this.addMessage("No Buy/Reoffer from a non-empty store");
                return false;
            }
            if (this.pTrans.transactions.contains(new TransactionComparatorByTType(new Buy()))) {
                return this.correctBuy(store);
            }
            Config config = AdminDocumentHandler.getConfig();
            return this.correctReoffer(store, config.MPD);
        }
        return true;
    }

    protected boolean correctReoffer(Store store, final double d) {
        List<Transaction> list = this.pTrans.transactions.filter(new TransactionComparatorByTType(new Reoffer()));
        List<Derivative> list2 = list.map(new List.Map<Transaction, Derivative>(){

            @Override
            public Derivative map(Transaction transaction) {
                return transaction.deriv;
            }
        });
        List<Derivative> list3 = DerivativesFinder.findDerivativesForSaleByOthers(store.stores, this.pTrans.player.id);
        List<Derivative> list4 = DerivativesFinder.findUniqueDerivatives(list3);
        List<Derivative> list5 = list4.map(new List.Map<Derivative, Derivative>(){

            @Override
            public Derivative map(Derivative derivative) {
                double d2 = derivative.price.val - d;
                return derivative.reoffer(RuleChecker.this.pTrans.player.id, new Price(d2 > 0.0 ? d2 : 0.0));
            }
        });
        if (list2.length() < list5.length()) {
            this.addMessage("Incorrect reoffering - too few Derivatives.");
            return false;
        }
        for (Derivative derivative : list5) {
            if (list2.contains(new CheaperDerivativeComparator(derivative))) continue;
            this.addMessage("Incorrect reoffering - price too high");
            return false;
        }
        return true;
    }

    protected boolean correctBuy(Store store) {
        List<Derivative> list = DerivativesFinder.findDerivativesForSale(store.stores);
        Transaction transaction = this.pTrans.transactions.find(new TransactionComparatorByTType(new Buy()));
        if (!list.contains(new DerivativeComparator(transaction.deriv))) {
            this.addMessage("Non-existant derivative bought");
            return false;
        }
        if (transaction.deriv.seller.equals(this.pTrans.player.id)) {
            this.addMessage("Player bought from itself");
            return false;
        }
        return true;
    }

    protected boolean emptyStoreBuyReoffer(Store store) {
        if (store.stores.isEmpty() || DerivativesFinder.findDerivativesForSaleByOthers(store.stores, this.pTrans.player.id).isEmpty()) {
            for (Transaction transaction : this.pTrans.transactions) {
                if (!transaction.ttype.getClass().equals(Buy.class) && !transaction.ttype.getClass().equals(Reoffer.class)) continue;
                this.addMessage("Buy/Reoffer from an empty store");
                return false;
            }
        }
        return true;
    }

    protected boolean isCreateRuleFollowed(Store store, Game.GameType gameType) {
        if (!this.pTrans.transactions.contains(new TransactionComparatorByTType(new Create()))) {
            this.addMessage("Player did not create a derivative");
            return false;
        }
        List<Transaction> list = this.pTrans.transactions.filter(new TransactionComparatorByTType(new Create()));
        for (Transaction transaction : list) {
            List<Derivative> list2 = DerivativesFinder.findDerivativesForSale(store.stores);
            if (list2.contains(new DerivativeComparatorByType(transaction.deriv))) {
                this.addMessage("Created a derivative of an existing type");
                return false;
            }
            if (transaction.deriv.price.val > 1.0 || transaction.deriv.price.val < 0.0) {
                this.addMessage("Illegally priced derivative [" + transaction.deriv.price.val + "]");
                return false;
            }
            if (gameType.compareTo(Game.GameType.BASEBALL) == 0 || gameType.compareTo(Game.GameType.FASTPITCH) == 0) continue;
            if (gameType.compareTo(Game.GameType.SLOWPITCH) == 0) {
                TypeInstance typeInstance = null;
                List<TypeInstance> list3 = transaction.deriv.type.instances.sort(new TypeInstanceComparator());
                for (TypeInstance typeInstance2 : list3) {
                    if (typeInstance != null && !RuleChecker.implies(typeInstance, typeInstance2)) {
                        this.addMessage("Violated Slowpitch creation rule.");
                        return false;
                    }
                    typeInstance = typeInstance2;
                }
                continue;
            }
            if (gameType.compareTo(Game.GameType.TBALL) != 0 || transaction.deriv.type.instances.length() <= 1) continue;
            this.addMessage("Violated T-Ball creation rule.");
            return false;
        }
        return true;
    }

    private static boolean implies(TypeInstance typeInstance, TypeInstance typeInstance2) {
        boolean bl = true;
        int n = typeInstance.r.v;
        for (int i = typeInstance2.r.v; bl && i > 0; i /= 2) {
            bl &= n % 2 >= i % 2;
            n /= 2;
        }
        return bl;
    }

    protected boolean isDeliveryRuleFollowed(Store store) {
        List<Transaction> list = this.pTrans.transactions.filter(new TransactionComparatorByTType(new Deliver()));
        List<Object> list2 = List.create(new Object[0]);
        for (Transaction object : list) {
            list2 = list2.push(object.deriv);
        }
        List<Derivative> list3 = DerivativesFinder.findDersThatNeedRM(store.stores, this.pTrans.player);
        if (!list2.same((List<Object>)list3, new DerivativeComparatorForList())) {
            this.addMessage("Incorrect number of delivered Derivatives");
            return false;
        }
        for (Derivative derivative : list2) {
            if (this.validRawMaterial(derivative)) continue;
            return false;
        }
        return true;
    }

    protected boolean validRawMaterial(Derivative derivative) {
        if (!derivative.optraw.isSome()) {
            this.addMessage("No RawMaterial found in delivered Derivative");
            return false;
        }
        for (Constraint constraint : derivative.optraw.inner().instance.cs) {
            if (!derivative.type.instances.contains(new TypeInstance(constraint.r))) {
                this.addMessage("RawMaterial with Type not specified in Derivative found");
                return false;
            }
            List<Variable> list = constraint.vs;
            if (list.length() != 3) {
                this.addMessage("Constraint with too few Variables found");
                return false;
            }
            while (list.length() > 0) {
                Variable variable = list.top();
                if (!(list = list.pop()).contains(variable)) continue;
                this.addMessage("Duplicate Variable found in Constraint: " + constraint.print() + "");
                return false;
            }
        }
        return true;
    }

    protected boolean isFinishRuleFollowed(Store store) {
        List<Transaction> list = this.pTrans.transactions.filter(new TransactionComparatorByTType(new Finish()));
        List<Object> list2 = List.create(new Object[0]);
        for (Transaction object : list) {
            list2 = list2.push(object.deriv);
        }
        List<Derivative> list3 = DerivativesFinder.findDersThatNeedFinishing(store.stores, this.pTrans.player);
        if (!list2.same((List<Object>)list3, new DerivativeComparatorForList())) {
            this.addMessage("Incorrect number of finished derivatives");
            return false;
        }
        for (Derivative derivative : list2) {
            Assignment assignment2 = derivative.optfinished.inner().ip.assignment;
            RawMaterial rawMaterial = derivative.optraw.inner();
            if (SufficientAssignment.good(rawMaterial, assignment2)) continue;
            this.addMessage("Insufficient assignment");
            return false;
        }
        return true;
    }
}

