/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.perform;

import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.dispatch.ConstrEntry;
import edu.neu.ccs.demeterf.dispatch.DBEntry;
import edu.neu.ccs.demeterf.dispatch.MethodEntry;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDB<M> {
    protected DBEntry<M>[] methods;

    public MethodDB(List<DBEntry<M>> list) {
        this.methods = list.toArray(new DBEntry[list.length()]);
    }

    public static MethodDB<Method> createMethodDB(Class<?> clazz, String string) {
        return Help.createMethodDB(clazz, string);
    }

    public static MethodDB<Constructor<?>> createConstrDB(Class<?> clazz) {
        return Help.createConstrDB(clazz);
    }

    public DBEntry<M> matchEntryFast(Class<?>[] classArray, int n2) {
        int n3 = this.methods.length;
        DBEntry<M> dBEntry = null;
        for (int j = 0; j < n3; ++j) {
            DBEntry<M> dBEntry2 = this.methods[j];
            if (!MethodDB.applicable(classArray, n2, dBEntry2) || dBEntry != null && !MethodDB.compare(dBEntry2, dBEntry)) continue;
            dBEntry = dBEntry2;
        }
        return dBEntry;
    }

    private static <M> boolean applicable(Class<?>[] classArray, int n2, DBEntry<M> dBEntry) {
        if (dBEntry.numArgs() > n2) {
            return false;
        }
        for (int j = 0; j < dBEntry.numArgs(); ++j) {
            if (dBEntry.arg(j).isAssignableFrom(classArray[j])) continue;
            return false;
        }
        return true;
    }

    static <M> boolean compare(DBEntry<M> dBEntry, DBEntry<M> dBEntry2) {
        int n2 = Math.min(dBEntry.numArgs(), dBEntry2.numArgs());
        for (int j = 0; j < n2; ++j) {
            if (dBEntry.arg(j).equals(dBEntry2.arg(j))) continue;
            return !dBEntry.arg(j).isAssignableFrom(dBEntry2.arg(j));
        }
        return dBEntry.numArgs() > dBEntry2.numArgs();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Help {
        Help() {
        }

        public static List<DBEntry<Method>> getMethods(Class<?> clazz, String string) {
            List<DBEntry<Method>> list = List.create(new DBEntry[0]);
            while (clazz != null && !clazz.equals(Object.class)) {
                for (Method method : clazz.getDeclaredMethods()) {
                    MethodEntry methodEntry;
                    if (!method.getName().equals(string) || list.index(methodEntry = new MethodEntry(method)) >= 0) continue;
                    list = list.push(methodEntry);
                }
                clazz = clazz.getSuperclass();
            }
            return list;
        }

        public static MethodDB<Method> createMethodDB(Class<?> clazz, String string) {
            return new MethodDB<Method>(Help.getMethods(clazz, string));
        }

        public static MethodDB<Constructor<?>> createConstrDB(Class<?> clazz) {
            List list = List.create(new DBEntry[0]);
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                list = list.push(new ConstrEntry(constructor));
            }
            return new MethodDB(list);
        }
    }
}

