/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.parallel;

import edu.neu.ccs.demeterf.Augmentor;
import edu.neu.ccs.demeterf.Builder;
import edu.neu.ccs.demeterf.BuilderAugmentor;
import edu.neu.ccs.demeterf.Control;
import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.Traversal;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.util.Util;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParTraversal2
extends Traversal {
    private boolean parallel = true;

    public ParTraversal2(Builder builder, Augmentor augmentor) {
        this(builder, augmentor, Control.everywhere());
    }

    public ParTraversal2(Builder builder, Augmentor augmentor, Control control) {
        super(builder, augmentor, control);
    }

    public ParTraversal2(Builder builder) {
        this(builder, new Augmentor(){}, Control.everywhere());
    }

    public ParTraversal2(Builder builder, Control control) {
        super(builder, new Augmentor(){}, control);
    }

    public ParTraversal2(BuilderAugmentor builderAugmentor) {
        super((Builder)builderAugmentor, builderAugmentor);
    }

    public ParTraversal2(BuilderAugmentor builderAugmentor, Control control) {
        super(builderAugmentor, builderAugmentor, control);
    }

    public ParTraversal2(ID iD) {
        super((Builder)iD, iD);
    }

    @Override
    public <Ret> Ret traverse(Object object) {
        Class<?> clazz = object.getClass();
        if (this.control.isBuiltIn(clazz)) {
            return (Ret)this.applyBuilder(new Object[]{object}, true);
        }
        List<Field> list = Util.getFuncFields(clazz);
        int n2 = list.length();
        Object[] objectArray = new Object[n2 + 1];
        objectArray[0] = object;
        try {
            SubTravP[] subTravPArray = new SubTravP[n2 - 1];
            int n3 = 0;
            for (Field field : list.pop()) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                subTravPArray[n3++] = new SubTravS(field.get(object), this);
            }
            Field field = list.top();
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            objectArray[1] = this.traverse(field.get(object));
            ++n2;
            for (n3 = 2; n3 < n2; ++n3) {
                objectArray[n3] = subTravPArray[n3 - 2].waitDone();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        return (Ret)this.applyBuilder(objectArray, false);
    }

    public <Ret> Ret traverseP(Object object) {
        Class<?> clazz = object.getClass();
        if (this.control.isBuiltIn(clazz)) {
            return (Ret)this.applyBuilder(new Object[]{object}, true);
        }
        List<Field> list = Util.getFuncFields(clazz);
        int n2 = list.length();
        Object[] objectArray = new Object[n2 + 1];
        objectArray[0] = object;
        try {
            SubTravS[] subTravSArray = new SubTravS[n2 - 1];
            int n3 = 0;
            for (Field field : list.pop()) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                subTravSArray[n3++] = new SubTravS(field.get(object), this);
            }
            Field field = list.top();
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            objectArray[1] = this.traverse(field.get(object));
            ++n2;
            for (n3 = 2; n3 < n2; ++n3) {
                objectArray[n3] = subTravSArray[n3 - 2].waitDone();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        return (Ret)this.applyBuilder(objectArray, false);
    }

    public <Ret> Ret traverseS(Object object) {
        Class<?> clazz = object.getClass();
        if (this.control.isBuiltIn(clazz)) {
            return (Ret)this.applyBuilder(new Object[]{object}, true);
        }
        List<Field> list = Util.getFuncFields(clazz);
        int n2 = list.length();
        Object[] objectArray = new Object[n2 + 1];
        objectArray[0] = object;
        try {
            int n3 = 1;
            for (Field field : list) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                objectArray[n3++] = this.traverseS(field.get(object));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        return (Ret)this.applyBuilder(objectArray, false);
    }

    static class SubTravS
    extends SubTravP {
        SubTravS(Object object, ParTraversal2 parTraversal2) {
            super(object, parTraversal2);
        }

        public void run() {
            long l2 = System.currentTimeMillis();
            this.setDone(this.trav.traverseS(this.tobj));
            System.out.println("THREAD : " + (System.currentTimeMillis() - l2));
        }

        synchronized void setDone(Object object) {
            this.res = object;
            this.done = true;
            this.notify();
        }

        synchronized Object waitDone() {
            if (!this.done) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println(" ** Error Waiting on Thread!!");
                }
            }
            return this.res;
        }
    }

    static class SubTravP
    extends Thread {
        final Object tobj;
        final ParTraversal2 trav;
        Object res;
        boolean done = false;

        SubTravP(Object object, ParTraversal2 parTraversal2) {
            this.tobj = object;
            this.trav = parTraversal2;
            this.start();
        }

        public void run() {
            long l2 = System.currentTimeMillis();
            this.setDone(this.trav.traverseP(this.tobj));
            System.out.println("THREAD : " + (System.currentTimeMillis() - l2));
        }

        synchronized void setDone(Object object) {
            this.res = object;
            this.done = true;
            this.notify();
        }

        synchronized Object waitDone() {
            if (!this.done) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println(" ** Error Waiting on Thread!!");
                }
            }
            return this.res;
        }
    }
}

