/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeSort {
    static void p(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        int n2 = stringArray.length > 0 ? Integer.parseInt(stringArray[0]) : 2000;
        L<Integer> l2 = MergeSort.rand(new id(), n2);
        MergeSort.p(" Length = " + n2);
        MergeSort.p("  Sort: " + new Sorter<Integer>().timesort(l2));
        MergeSort.p(" PSort: " + new PSorter<Integer>().timesort(l2));
        MergeSort.p(" ASort: " + new ASorter().timesort(l2, new Integer[n2]));
    }

    static <D extends Comparable<D>> L<D> make(D ... DArray) {
        return MergeSort.make(DArray, (int)0, (int)DArray.length);
    }

    static <D extends Comparable<D>> L<D> make(D[] DArray, int n2, int n3) {
        return n2 == n3 ? new L() : MergeSort.make(DArray, (int)(n2 + 1), (int)n3).push(DArray[n2]);
    }

    static <D extends Comparable<D>> L<D> make(Creator<D> creator, int ... nArray) {
        return MergeSort.make(creator, nArray, nArray.length - 1);
    }

    static <D extends Comparable<D>> L<D> make(Creator<D> creator, int[] nArray, int n2) {
        return n2 < 0 ? new L() : MergeSort.make(creator, nArray, n2 - 1).push((Comparable)creator.make(nArray[n2]));
    }

    static int randInt() {
        return (int)(Math.random() * 20.0);
    }

    static <D extends Comparable<D>> L<D> rand(Creator<D> creator, int n2) {
        return n2 == 0 ? new L() : MergeSort.rand(creator, n2 - 1).push((Comparable)creator.make(MergeSort.randInt()));
    }

    static <D extends Comparable<D>> L<D> merge(L<D> l2, L<D> l3) {
        if (l2.isEmpty()) {
            return l3;
        }
        if (l3.isEmpty()) {
            return l2;
        }
        if (l2.first().compareTo(l3.first()) <= 0) {
            return MergeSort.merge(l2.rest(), l3).push(l2.first());
        }
        return MergeSort.merge(l2, l3.rest()).push(l3.first());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class C<D extends Comparable<D>>
    extends L<D> {
        D f;
        L<D> r;

        C(D d2, L<D> l2) {
            this.f = d2;
            this.r = l2;
        }

        @Override
        boolean isEmpty() {
            return false;
        }

        @Override
        D first() {
            return this.f;
        }

        @Override
        L<D> rest() {
            return this.r;
        }

        @Override
        int length() {
            return 1 + this.r.length();
        }

        @Override
        L<D> reverse(L<D> l2) {
            return this.r.reverse(l2.push(this.f));
        }

        @Override
        L<D> append(L<D> l2) {
            return this.r.append(l2).push(this.f);
        }

        @Override
        L.P<D> split(int n2, L<D> l2) {
            return n2 == 0 ? new L.P<D>(l2.reverse(), this) : this.r.split(n2 - 1, l2.push(this.f));
        }

        @Override
        public String toString() {
            return this.f + " " + this.r;
        }

        @Override
        D[] toArray(D[] DArray, int n2) {
            DArray[n2] = this.f;
            return this.r.toArray((Comparable[])DArray, n2 + 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class L<D extends Comparable<D>> {
        L() {
        }

        boolean isEmpty() {
            return true;
        }

        D first() {
            throw new RuntimeException("L.first() Bad");
        }

        L<D> rest() {
            throw new RuntimeException("L.rest() Bad");
        }

        int length() {
            return 0;
        }

        L<D> reverse() {
            return this.reverse(new L<D>());
        }

        L<D> reverse(L<D> l2) {
            return l2;
        }

        L<D> push(D d2) {
            return new C<D>(d2, this);
        }

        L<D> append(L<D> l2) {
            return l2;
        }

        P<D> split(int n2) {
            return this.split(n2, new L<D>());
        }

        P<D> split(int n2, L<D> l2) {
            throw new RuntimeException("L.split() Bad");
        }

        public String toString() {
            return "";
        }

        D[] toArray(D[] DArray) {
            return this.toArray((Comparable[])DArray, 0);
        }

        D[] toArray(D[] DArray, int n2) {
            return DArray;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class P<D extends Comparable<D>> {
            L<D> lt;
            L<D> rt;

            P(L<D> l2, L<D> l3) {
                this.lt = l2;
                this.rt = l3;
            }

            public String toString() {
                return "<" + this.lt + " :: " + this.rt + ">";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PSorter<D extends Comparable<D>>
    extends Sorter<D> {
        PSorter() {
        }

        @Override
        public L<D> sort(L<D> l2) {
            int n2 = l2.length();
            if (n2 <= 1) {
                return l2;
            }
            L.P<D> p2 = l2.split(n2 / 2);
            Thrd thrd = new Thrd(p2.lt);
            thrd.start();
            L l3 = this.recsort(p2.rt);
            p2 = null;
            thrd.waitFor();
            return MergeSort.merge(thrd.res, l3);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Thrd
        extends Thread {
            L<D> lst;
            L<D> res;
            boolean fin = false;

            Thrd(L<D> l2) {
                this.lst = l2;
                this.res = null;
            }

            @Override
            public void run() {
                this.res = PSorter.this.recsort(this.lst);
                this.done();
            }

            synchronized void done() {
                this.fin = true;
                this.notifyAll();
            }

            synchronized void waitFor() {
                try {
                    while (!this.fin) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ASorter<D extends Comparable<D>>
    extends Sorter<D> {
        ASorter() {
        }

        public Sorter.T timesort(L<D> l2, D[] objectArray) {
            objectArray = l2.toArray((Comparable[])objectArray);
            System.gc();
            Thread.yield();
            long l3 = System.currentTimeMillis();
            Arrays.sort(objectArray);
            return new Sorter.T(System.currentTimeMillis() - l3, MergeSort.make((Comparable[])objectArray));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Sorter<D extends Comparable<D>> {
        Sorter() {
        }

        public L<D> sort(L<D> l2) {
            return this.recsort(l2);
        }

        public L<D> recsort(L<D> l2) {
            int n2 = l2.length();
            if (n2 <= 1) {
                return l2;
            }
            L.P<D> p2 = l2.split(n2 / 2);
            return MergeSort.merge(this.recsort(p2.lt), this.recsort(p2.rt));
        }

        public T timesort(L<D> l2) {
            System.gc();
            Thread.yield();
            long l3 = System.currentTimeMillis();
            L<D> l4 = this.sort(l2);
            return new T(System.currentTimeMillis() - l3, l4);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class T {
            long mil;
            L<D> lst;

            T(long l2, L<D> l3) {
                this.mil = l2;
                this.lst = l3;
            }

            public String toString() {
                return " MSec: " + this.mil;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class id
    extends Creator<Integer> {
        id() {
        }

        @Override
        Integer make(int n2) {
            return n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Creator<D> {
        Creator() {
        }

        abstract D make(int var1);
    }
}

