/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.evergreen.ir;

import edu.neu.ccs.evergreen.ir.RelationCore;

public class RelationNumberUtil {
    public static int or(int rank, int ... variablePositions) {
        int relationNumber = 0;
        int[] nArray = variablePositions;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int variablePosition = nArray[n];
            relationNumber |= RelationCore.getMagicNumber(rank, variablePosition, 1);
            ++n;
        }
        return relationNumber;
    }

    public static int and(int rank, int ... variablePositions) {
        int relationNumber = RelationCore.getMask(rank);
        int[] nArray = variablePositions;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int variablePosition = nArray[n];
            relationNumber &= RelationCore.getMagicNumber(rank, variablePosition, 1);
            ++n;
        }
        return relationNumber;
    }

    public static int nMap(int relationNumber, int rank, int ... variablePositions) {
        int[] nArray = variablePositions;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int variablePosition = nArray[n];
            relationNumber = RelationCore.nMap(relationNumber, rank, variablePosition);
            ++n;
        }
        return relationNumber;
    }

    public static int imply(int rank, int ... variablePositions) {
        if (variablePositions.length > 2) {
            throw new IllegalArgumentException("imply supports up to 2 variables. Passed " + variablePositions.length);
        }
        int relationNumber = RelationNumberUtil.or(rank, variablePositions[0], variablePositions[1]);
        return RelationNumberUtil.nMap(relationNumber, rank, variablePositions[0]);
    }

    public static int equiv(int rank, int ... variablePositions) {
        if (variablePositions.length > 2) {
            throw new IllegalArgumentException("equiv supports up to 2 variables. Passed " + variablePositions.length);
        }
        int bothNeg = RelationNumberUtil.and(rank, variablePositions[0], variablePositions[1]);
        bothNeg = RelationNumberUtil.nMap(bothNeg, rank, variablePositions);
        int bothPos = RelationNumberUtil.and(rank, variablePositions[0], variablePositions[1]);
        return bothNeg | bothPos;
    }

    public static int xor(int rank, int ... variablePositions) {
        if (variablePositions.length > 2) {
            throw new IllegalArgumentException("xor supports up to 2 variables. Passed " + variablePositions.length);
        }
        int posNeg = RelationNumberUtil.and(rank, variablePositions[0], variablePositions[1]);
        posNeg = RelationNumberUtil.nMap(posNeg, rank, variablePositions[1]);
        int negPos = RelationNumberUtil.and(rank, variablePositions[0], variablePositions[1]);
        negPos = RelationNumberUtil.nMap(negPos, rank, variablePositions[0]);
        return posNeg | negPos;
    }

    public static int xTrueVars(int rank, int numberOfTrueVars) {
        int relationNumber = 0;
        int i = 0;
        while (i < 1 << rank) {
            if (RelationCore.ones(i, 3) == numberOfTrueVars) {
                relationNumber |= 1 << i;
            }
            ++i;
        }
        return relationNumber;
    }

    public static void main(String[] args) {
        System.out.println("-3");
        System.out.println("-3");
        System.out.println(RelationNumberUtil.xTrueVars(3, 0));
        System.out.println(RelationNumberUtil.xTrueVars(3, 1));
        System.out.println(RelationNumberUtil.xTrueVars(3, 2));
        System.out.println(RelationNumberUtil.xTrueVars(3, 3));
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        int[] all = nArray;
        System.out.println(RelationNumberUtil.nMap(RelationNumberUtil.xTrueVars(3, 1), 3, all));
        System.out.println(RelationNumberUtil.and(3, all));
        System.out.println(RelationNumberUtil.or(3, all));
    }
}

