/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.evergreen.ir;

import edu.neu.ccs.evergreen.ir.RelationCore;
import org.junit.Assert;
import org.junit.Test;

public class RelationCoreNmapTest {
    int maxRank = 5;

    @Test
    public final void testNMap() {
        int variablePosition;
        int rank = 1;
        while (rank < this.maxRank) {
            variablePosition = 0;
            while (variablePosition < rank) {
                int value = 0;
                while (value <= 1) {
                    int relationNumber = RelationCore.getMagicNumber(rank, variablePosition, value);
                    int nMappedRelationNumber = RelationCore.nMap(relationNumber, rank, variablePosition);
                    int mask = RelationCore.getMask(rank);
                    Assert.assertTrue((mask - nMappedRelationNumber == relationNumber ? 1 : 0) != 0);
                    ++value;
                }
                ++variablePosition;
            }
            ++rank;
        }
        rank = 1;
        while (rank < this.maxRank) {
            int originalRelationNumber;
            int nMappedRelationNumber;
            int variablePosition2;
            int relationNumber;
            if (RelationCore.getMask(rank) > 0) {
                relationNumber = 0;
                while (relationNumber < RelationCore.getMask(rank)) {
                    variablePosition2 = 0;
                    while (variablePosition2 < rank) {
                        nMappedRelationNumber = RelationCore.nMap(relationNumber, rank, variablePosition2);
                        originalRelationNumber = RelationCore.nMap(nMappedRelationNumber, rank, variablePosition2);
                        Assert.assertTrue((relationNumber == originalRelationNumber ? 1 : 0) != 0);
                        ++variablePosition2;
                    }
                    ++relationNumber;
                }
            } else {
                relationNumber = -1;
                while (relationNumber < 0x7FFFFFFE) {
                    variablePosition2 = 0;
                    while (variablePosition2 < rank) {
                        nMappedRelationNumber = RelationCore.nMap(relationNumber, rank, variablePosition2);
                        originalRelationNumber = RelationCore.nMap(nMappedRelationNumber, rank, variablePosition2);
                        Assert.assertTrue((relationNumber == originalRelationNumber ? 1 : 0) != 0);
                        ++variablePosition2;
                    }
                    ++relationNumber;
                }
                variablePosition = 0;
                while (variablePosition < rank) {
                    int relationNumber2 = Integer.MAX_VALUE;
                    nMappedRelationNumber = RelationCore.nMap(relationNumber2, rank, variablePosition);
                    originalRelationNumber = RelationCore.nMap(nMappedRelationNumber, rank, variablePosition);
                    Assert.assertTrue((relationNumber2 == originalRelationNumber ? 1 : 0) != 0);
                    ++variablePosition;
                }
            }
            ++rank;
        }
    }
}

