/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.evergreen.ir;

public class CustomCounter {
    private int noOfDigits;
    private int start;
    private int end;
    private int[] digits;

    public CustomCounter(int noOfDigits, int start, int end) {
        this.noOfDigits = noOfDigits;
        this.start = start;
        this.end = end;
        this.digits = new int[noOfDigits];
        this.restart();
    }

    public int[] next() {
        int i = 0;
        while (i < this.digits.length) {
            int n = i;
            this.digits[n] = this.digits[n] + 1;
            if (this.digits[i] <= this.end) break;
            this.digits[i] = this.start;
            ++i;
        }
        return this.getPermutation();
    }

    public boolean hasNext() {
        int[] nArray = this.digits;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int digit = nArray[n];
            if (digit != this.end) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void restart() {
        int i = 0;
        while (i < this.digits.length) {
            this.digits[i] = this.start;
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = this.digits.length - 1;
        while (i > -1) {
            sb.append(this.digits[i]);
            --i;
        }
        return sb.toString();
    }

    public boolean isPermutation() {
        int i = 0;
        while (i < this.digits.length) {
            int j = i + 1;
            while (j < this.digits.length) {
                if (this.digits[i] == this.digits[j]) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public int[] nextPermutation() {
        do {
            this.next();
        } while (this.hasNext() && !this.isPermutation());
        return this.getPermutation();
    }

    public boolean hasNextPermutation() {
        if (!this.hasNext()) {
            return false;
        }
        boolean returnVal = false;
        int[] tmp = new int[this.digits.length];
        int i = 0;
        while (i < this.digits.length) {
            tmp[i] = this.digits[i];
            ++i;
        }
        this.nextPermutation();
        returnVal = this.isPermutation();
        i = 0;
        while (i < this.digits.length) {
            this.digits[i] = tmp[i];
            ++i;
        }
        return returnVal;
    }

    public boolean isDistinctPermutation() {
        int i = 0;
        while (i < this.digits.length) {
            int j = i + 1;
            while (j < this.digits.length) {
                if (this.digits[i] <= this.digits[j]) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public int[] nextDistinctPermutation() {
        do {
            this.next();
        } while (this.hasNext() && !this.isDistinctPermutation());
        return this.getPermutation();
    }

    public boolean hasNextDistinctPermutation() {
        if (!this.hasNext()) {
            return false;
        }
        boolean returnVal = false;
        int[] tmp = new int[this.digits.length];
        int i = 0;
        while (i < this.digits.length) {
            tmp[i] = this.digits[i];
            ++i;
        }
        this.nextDistinctPermutation();
        returnVal = this.isDistinctPermutation();
        i = 0;
        while (i < this.digits.length) {
            this.digits[i] = tmp[i];
            ++i;
        }
        return returnVal;
    }

    public int[] filter(int[] filter) {
        int count = 0;
        int[] nArray = filter;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int i = nArray[n];
            if (i == 1) {
                ++count;
            }
            ++n;
        }
        int[] tmp = new int[count];
        count = 0;
        int i = 0;
        while (i < this.digits.length) {
            if (filter[i] == 1) {
                tmp[count++] = this.digits[i];
            }
            ++i;
        }
        return tmp;
    }

    protected Object clone() throws CloneNotSupportedException {
        CustomCounter p = new CustomCounter(this.noOfDigits, this.start, this.end);
        int i = 0;
        while (i < this.digits.length) {
            p.digits[i] = this.digits[i];
            ++i;
        }
        return p;
    }

    public int[] getPermutation() {
        int[] digitsCopy = new int[this.noOfDigits];
        int i = 0;
        while (i < this.digits.length) {
            digitsCopy[i] = this.digits[i];
            ++i;
        }
        return digitsCopy;
    }

    public static void main(String[] args) {
        CustomCounter c = new CustomCounter(5, 0, 1);
        while (c.hasNext()) {
            c.next();
            System.out.println(c);
        }
        System.out.println("============");
        c = new CustomCounter(2, 1, 5);
        while (c.hasNextPermutation()) {
            c.nextPermutation();
            System.out.println(c);
        }
        System.out.println("============");
        c = new CustomCounter(2, 1, 5);
        while (c.hasNextDistinctPermutation()) {
            c.nextDistinctPermutation();
            System.out.println(c);
        }
        System.out.println("============");
        int[] f1 = new int[2];
        int[] f2 = new int[]{1, 1};
        int[] x = c.filter(f1);
        int[] y = c.filter(f2);
        int i = 0;
        while (i < x.length) {
            System.out.println("x[" + i + "]" + x[i]);
            ++i;
        }
        i = 0;
        while (i < y.length) {
            System.out.println("y[" + i + "]" + y[i]);
            ++i;
        }
    }
}

