/*
 * Decompiled with CFR 0.152.
 */
package player;

import edu.neu.ccs.demeterf.demfgen.lib.List;
import gen.Derivative;
import gen.FinishedProduct;
import gen.ParseException;
import gen.RawMaterial;
import gen.RawMaterialInstance;
import gen.RelationNr;
import hidden.Tools;
import java.text.DecimalFormat;
import player.GenericPlayer;
import player.PlayerI;
import player.Util;

public class Test {
    static DecimalFormat formLong = new DecimalFormat("0.00000");
    static DecimalFormat formShort = new DecimalFormat("0.00");
    static final String undelivered = "deriv[\"GenericPlayer_undeliv\" 2 1 0.5   type[27 43]]";
    static final String unfinished = "deriv[\"GenericPlayer_unfin\" 2 1 0.25   type[27 ]   rm[  1: 27 a b c        1: 27 d e f        1: 27 f b d ]]";

    static void p(String string) {
        System.out.println(string.replace("\n", "\n        "));
    }

    public static void main(String[] stringArray) throws ParseException {
        long l = System.currentTimeMillis();
        Test.testDeliver();
        Test.p(Test.done(System.currentTimeMillis() - l));
    }

    static String done(long l) {
        return " Done: " + formShort.format((double)l / 1000.0) + " sec.";
    }

    static void testCoinFlip() {
        int n = 0;
        for (int i = 0; i < 100000; ++i) {
            if (!Util.coinFlip(0.12345)) continue;
            ++n;
        }
        Test.p(" * Bias of : 0.12345");
        Test.p(" *  Result : " + formLong.format((double)n / 100000.0));
        Test.p(" * Diff of : " + formLong.format(Math.abs(0.12345 - (double)n / 100000.0)));
    }

    static void testFinish() throws ParseException {
        PlayerI.FinishAgentI finishAgentI = new GenericPlayer().getFinishAgent();
        Derivative derivative = Derivative.parse((String)unfinished);
        FinishedProduct finishedProduct = finishAgentI.finishDerivative(derivative);
        Test.p(" What : " + derivative.print());
        Test.p("  Fin : " + finishedProduct.print());
    }

    static void testDeliver() throws ParseException {
        PlayerI.DeliverAgentI deliverAgentI = new GenericPlayer().getDeliverAgent();
        Derivative derivative = Derivative.parse((String)undelivered);
        Derivative derivative2 = deliverAgentI.deliverRawMaterial(derivative);
        Test.p(" What : " + derivative.print());
        Test.p("  Del : " + ((RawMaterial)derivative2.optraw.inner()).print());
    }

    static void testPrint() {
        long l = System.currentTimeMillis();
        RawMaterialInstance rawMaterialInstance = new RawMaterialInstance(Tools.symmetric(List.create(new RelationNr(5)), 50, 3));
        Test.p(Test.done(System.currentTimeMillis() - l));
    }
}

