/*
 * Decompiled with CFR 0.152.
 */
package utils;

import edu.neu.ccs.demeterf.TUCombiner;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import gen.Derivative;
import gen.Pair;
import gen.Player;
import gen.PlayerID;
import gen.PlayerStore;
import gen.Type;
import utils.DerivativeTypes;
import utils.DerivativesForSale;
import utils.DerivativesThatNeedFinishing;
import utils.DerivativesThatNeedRM;
import utils.DerivsFromOthers;
import utils.comparator.DerivativeComparatorByType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivativesFinder {
    public static List<Type> findExistingDerTypes(List<Pair<PlayerID, PlayerStore>> list) {
        return (List)TUCombiner.traverse(list, (TUCombiner)new DerivativeTypes());
    }

    public static List<Derivative> findDersThatNeedRM(List<Pair<PlayerID, PlayerStore>> list, Player player) {
        return (List)TUCombiner.traverse(list, (TUCombiner)new DerivativesThatNeedRM(player.id.id));
    }

    public static List<Derivative> findDersThatNeedFinishing(List<Pair<PlayerID, PlayerStore>> list, Player player) {
        return (List)TUCombiner.traverse(list, (TUCombiner)new DerivativesThatNeedFinishing(player.id.id));
    }

    public static List<Derivative> findDerivativesForSale(List<Pair<PlayerID, PlayerStore>> list) {
        return (List)TUCombiner.traverse(list, (TUCombiner)new DerivativesForSale());
    }

    public static List<Derivative> findDerivativesForSaleByOthers(List<Pair<PlayerID, PlayerStore>> list, PlayerID playerID) {
        return (List)TUCombiner.traverse(list, (TUCombiner)new DerivsFromOthers(playerID));
    }

    public static List<Derivative> findUniqueDerivatives(List<Derivative> list) {
        List list2 = List.create((Object[])new Object[0]);
        for (Derivative derivative : list) {
            if (!list2.contains((List.Pred)new DerivativeComparatorByType(derivative))) {
                list2 = list2.push((Object)derivative);
                continue;
            }
            DerivativeComparatorByType derivativeComparatorByType = new DerivativeComparatorByType(derivative);
            if (!(derivative.price.val < ((Derivative)list2.find((List.Pred)derivativeComparatorByType)).price.val)) continue;
            list2 = list2.replace((List.Pred)new DerivativeComparatorByType(derivative), (Object)derivative);
        }
        return list2;
    }
}

