/*
 * Decompiled with CFR 0.152.
 */
package gen;

import edu.neu.ccs.demeterf.control.Fields;
import edu.neu.ccs.demeterf.demfgen.lib.Option;
import gen.Display;
import gen.FinishedProduct;
import gen.ParseException;
import gen.PlayerID;
import gen.Price;
import gen.PrintHeap;
import gen.RawMaterial;
import gen.RawMaterialInstance;
import gen.TheParser;
import gen.Type;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Derivative {
    public String name;
    public PlayerID seller;
    public Option<PlayerID> optbuyer;
    public Price price;
    public Type type;
    public Option<RawMaterial> optraw;
    public Option<FinishedProduct> optfinished;

    public Derivative(String string, PlayerID playerID, Option<PlayerID> option, Price price2, Type type2, Option<RawMaterial> option2, Option<FinishedProduct> option3) {
        this.name = string;
        this.seller = playerID;
        this.optbuyer = option;
        this.price = price2;
        this.type = type2;
        this.optraw = option2;
        this.optfinished = option3;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Derivative)) {
            return false;
        }
        Derivative derivative = (Derivative)object;
        return this.name.equals(derivative.name) && ((Object)this.seller).equals(derivative.seller) && this.optbuyer.equals(derivative.optbuyer) && ((Object)this.price).equals(derivative.price) && ((Object)this.type).equals(derivative.type) && this.optraw.equals(derivative.optraw) && this.optfinished.equals(derivative.optfinished);
    }

    public static Derivative parse(String string) throws ParseException {
        return new TheParser(new StringReader(string)).parse_Derivative();
    }

    public static Derivative parse(InputStream inputStream) throws ParseException {
        return new TheParser(inputStream).parse_Derivative();
    }

    public static Derivative parse(Reader reader) throws ParseException {
        return new TheParser(reader).parse_Derivative();
    }

    public String printIter() {
        String string = "deriv[";
        string = string + "\"" + this.name + "\" " + this.seller.print() + " ";
        string = string + (this.optbuyer.isSome() ? ((PlayerID)this.optbuyer.inner()).print() : "");
        string = string + " " + this.price.print() + " " + this.type.printIter();
        string = string + (this.optraw.isSome() ? ((RawMaterial)this.optraw.inner()).printIter() : "");
        string = string + " " + (this.optfinished.isSome() ? ((FinishedProduct)this.optfinished.inner()).printIter() : "");
        string = string + "]";
        return string;
    }

    public Derivative(String string, PlayerID playerID, Price price2, Type type2) {
        this(string, playerID, (Option<PlayerID>)Option.none(), price2, type2, (Option<RawMaterial>)Option.none(), (Option<FinishedProduct>)Option.none());
    }

    public Derivative buy(PlayerID playerID) {
        if (this.optbuyer.isSome()) {
            throw new RuntimeException("Derivative " + this.name + " Already Bought!");
        }
        return new Derivative(this.name, this.seller, (Option<PlayerID>)Option.some((Object)playerID), this.price, this.type, this.optraw, this.optfinished);
    }

    public Derivative deliver(RawMaterialInstance rawMaterialInstance) {
        if (this.optraw.isSome()) {
            throw new RuntimeException("Derivative " + this.name + " Already Delivered!");
        }
        return new Derivative(this.name, this.seller, this.optbuyer, this.price, this.type, (Option<RawMaterial>)Option.some((Object)new RawMaterial(rawMaterialInstance)), this.optfinished);
    }

    public Derivative finish(FinishedProduct finishedProduct) {
        if (this.optfinished.isSome()) {
            throw new RuntimeException("Derivative " + this.name + " Already Finished!");
        }
        return new Derivative(this.name, this.seller, this.optbuyer, this.price, this.type, this.optraw, (Option<FinishedProduct>)Option.some((Object)finishedProduct));
    }

    public Derivative reoffer(PlayerID playerID, Price price2) {
        return new Derivative(this.name, playerID, this.optbuyer, price2, this.type, this.optraw, this.optfinished);
    }

    public String display() {
        return Display.DisplayM(this);
    }

    public String print() {
        return PrintHeap.PrintHeapM(this);
    }

    public static class optfinished
    extends Fields.any {
    }

    public static class optraw
    extends Fields.any {
    }

    public static class type
    extends Fields.any {
    }

    public static class price
    extends Fields.any {
    }

    public static class optbuyer
    extends Fields.any {
    }

    public static class seller
    extends Fields.any {
    }

    public static class name
    extends Fields.any {
    }
}

