/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.inline;

import edu.neu.ccs.demeterf.Control;
import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.Traversal;
import edu.neu.ccs.demeterf.demfgen.Diff;
import edu.neu.ccs.demeterf.demfgen.classes.ClassDef;
import edu.neu.ccs.demeterf.demfgen.classes.DoGen;
import edu.neu.ccs.demeterf.demfgen.classes.Field;
import edu.neu.ccs.demeterf.demfgen.classes.Impl;
import edu.neu.ccs.demeterf.demfgen.classes.ProdType;
import edu.neu.ccs.demeterf.demfgen.classes.SumType;
import edu.neu.ccs.demeterf.demfgen.classes.TypeDef;
import edu.neu.ccs.demeterf.demfgen.classes.TypeDefParams;
import edu.neu.ccs.demeterf.demfgen.classes.TypeUse;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.demfgen.lib.Option;
import edu.neu.ccs.demeterf.demfgen.lib.Set;
import edu.neu.ccs.demeterf.demfgen.lib.ident;
import edu.neu.ccs.demeterf.dispatch.Type;
import edu.neu.ccs.demeterf.inline.CPair;
import edu.neu.ccs.demeterf.inline.Checker;
import edu.neu.ccs.demeterf.inline.Help;
import edu.neu.ccs.demeterf.inline.SubTyping;
import edu.neu.ccs.demeterf.inline.ToLst;
import edu.neu.ccs.demeterf.inline.classes.Constr;
import edu.neu.ccs.demeterf.inline.classes.EnvEntry;
import edu.neu.ccs.demeterf.inline.classes.FunctionClass;
import edu.neu.ccs.demeterf.inline.classes.Meth;
import edu.neu.ccs.demeterf.inline.classes.TypeError;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Typer
extends ID {
    Traversal trav;
    List<TypeDef> types;
    FunctionClass func;
    Control ctrl;
    Option<Type> targ;
    SubTyping subs;
    Set<EnvEntry> results = Set.create(new Comparator<EnvEntry>(){

        @Override
        public int compare(EnvEntry envEntry, EnvEntry envEntry2) {
            return envEntry.type.print().compareTo(envEntry2.type.print());
        }
    });

    Typer(List<TypeDef> list, FunctionClass functionClass, Control control, SubTyping subTyping) {
        this(list, functionClass, control, Option.none(), subTyping);
    }

    Typer(List<TypeDef> list, FunctionClass functionClass, Control control, Option<Type> option, SubTyping subTyping) {
        this.types = list;
        this.func = functionClass;
        this.ctrl = control;
        this.targ = option;
        this.subs = subTyping;
        this.trav = Traversal.onestep(this);
    }

    synchronized void addEnv(EnvEntry envEntry) {
        this.results = this.results.add(envEntry);
    }

    CPair recurse(String string, Set<String> set) {
        Help.print(" Recurse: " + string + "\n");
        if (Diff.d.builtIns.contains(string)) {
            List<Meth> list = this.func.allApplicable(List.create(this.subs.makeType(string)), this.subs);
            if (list.isEmpty()) {
                throw new TypeError("No Method for: " + string);
            }
            Meth meth = list.top();
            this.addEnv(new EnvEntry(this.subs.makeType(string), meth.ret, Option.some(meth)));
            return new CPair(list.top().ret);
        }
        TypeDef typeDef = Checker.defFor(this.subs.makeType(string), this.types);
        return this.recurse(typeDef, set);
    }

    CPair recurse(TypeDef typeDef, Set<String> set) {
        return (CPair)this.trav.traverse((Object)typeDef, set);
    }

    CPair combine(ClassDef classDef, DoGen doGen, ident ident2, TypeDefParams typeDefParams, ProdType prodType, Impl impl, Set<String> set) {
        return this.check("" + ident2 + typeDefParams.print(), prodType, set);
    }

    CPair combine(ClassDef classDef, DoGen doGen, ident ident2, TypeDefParams typeDefParams, SumType sumType, Impl impl, Set<String> set) {
        return this.check("" + ident2 + typeDefParams.print(), sumType, set);
    }

    CPair check(String string, ProdType prodType, Set<String> set) {
        Help.print(" Check Concrete: " + string + "\n");
        TypeUse typeUse = this.subs.makeType(string);
        List<TypeUse> list = ToLst.toList(prodType.fields, Field.class).map(new List.Map<Field, TypeUse>(){

            @Override
            public TypeUse map(Field field) {
                return field.type;
            }
        });
        final Set<String> set2 = set.add(string);
        List<Option<CPair>> list2 = list.map(new List.Map<TypeUse, Option<CPair>>(){

            @Override
            public Option<CPair> map(TypeUse typeUse) {
                if (set2.contains(typeUse.print())) {
                    return Option.none();
                }
                return Option.some(Typer.this.recurse("" + typeUse.print(), (Set<String>)set2));
            }
        });
        List<Option<TypeUse>> list3 = list2.map(new List.Map<Option<CPair>, Option<TypeUse>>(){

            @Override
            public Option<TypeUse> map(Option<CPair> option) {
                return option.isSome() ? Option.some(option.inner().ret) : Option.none();
            }
        }).push(Option.some(this.subs.makeType(string)));
        List<Meth> list4 = this.func.allWithStar(list3, this.subs);
        String string2 = "(" + list3.toString(new List.Stringer<Option<TypeUse>>(){

            @Override
            public String toString(Option<TypeUse> option, List<Option<TypeUse>> list) {
                return (option.isSome() ? option.inner().print() : "*") + (list.isEmpty() ? "" : ",");
            }
        }) + ")";
        if (list4.length() == 0) {
            throw new TypeError("No Applicable Method: " + string2);
        }
        if (list4.length() > 1) {
            throw new TypeError("Too Many Methods [" + list4.length() + "] For: " + string2);
        }
        Meth meth = list4.top();
        List<Constr> list5 = this.discharge(typeUse, meth.ret, list2);
        int n2 = 1;
        for (TypeUse typeUse2 : list) {
            Constr constr;
            if (n2 < meth.args.length() && set.contains(typeUse2.print()) && !list5.contains(constr = new Constr(typeUse2, meth.args.lookup(n2)))) {
                list5 = list5.push(constr);
            }
            ++n2;
        }
        this.addEnv(new EnvEntry(typeUse, meth.ret, Option.some(meth)));
        return new CPair(meth.ret, list5);
    }

    CPair check(String string, SumType sumType, final Set<String> set) {
        Help.print(" Check Abstract: " + string + "\n");
        TypeUse typeUse = this.subs.makeType(string);
        List<TypeUse> list = ToLst.toList(sumType.subtypes, TypeUse.class);
        final Set<String> set2 = set.add(string);
        List<Option<CPair>> list2 = list.map(new List.Map<TypeUse, Option<CPair>>(){

            @Override
            public Option<CPair> map(TypeUse typeUse) {
                if (set2.contains(typeUse.print())) {
                    return Option.none();
                }
                return Option.some(Typer.this.recurse(typeUse.print(), (Set<String>)set2));
            }
        });
        final TypeUse typeUse2 = list2.fold(new List.Fold<Option<CPair>, TypeUse>(){

            @Override
            public TypeUse fold(Option<CPair> option, TypeUse typeUse) {
                if (typeUse == null) {
                    return option.isSome() ? option.inner().ret : typeUse;
                }
                if (!option.isSome()) {
                    return typeUse;
                }
                TypeUse typeUse2 = option.inner().ret;
                while (!Typer.this.subs.subtype(typeUse2, typeUse)) {
                    typeUse = Typer.this.subs.supertype(typeUse);
                }
                return typeUse;
            }
        }, null);
        if (typeUse2 == null) {
            throw new TypeError("All Recursive Subtypes for: " + string);
        }
        List<Constr> list3 = this.discharge(typeUse, typeUse2, list2);
        List<Constr> list4 = list.fold(new List.Fold<TypeUse, List<Constr>>(){

            @Override
            public List<Constr> fold(TypeUse typeUse, List<Constr> list) {
                if (!set.contains(typeUse.print())) {
                    return list;
                }
                Constr constr = new Constr(typeUse, typeUse2);
                return list.contains(constr) ? list : list.push(constr);
            }
        }, list3);
        this.addEnv(new EnvEntry(typeUse, typeUse2, Option.<Meth>none()));
        return new CPair(typeUse2, list4);
    }

    List<Constr> discharge(final TypeUse typeUse, final TypeUse typeUse2, List<Option<CPair>> list) {
        List<Constr> list2 = CPair.mergeAll(list);
        List<Constr> list3 = list2.filterout(new List.Pred<Constr>(){

            @Override
            public boolean huh(Constr constr) {
                return !constr.from.equals(typeUse) || Typer.this.subs.subtype(typeUse2, constr.res);
            }
        });
        if (!list3.isEmpty()) {
            throw new TypeError("Unsatisfied Constraints: " + list3.toString("\n", "   "));
        }
        return list2.filterout(new List.Pred<Constr>(){

            @Override
            public boolean huh(Constr constr) {
                return constr.from.equals(typeUse);
            }
        });
    }
}

