/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.demfgen.lib;

import edu.neu.ccs.demeterf.control.Fields;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.demfgen.lib.RBColor;
import edu.neu.ccs.demeterf.demfgen.lib.RBTree;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RBNode<X extends Comparable<X>>
extends RBTree<X> {
    public final RBColor color;
    public final X data;
    public final RBTree<X> left;
    public final RBTree<X> right;

    public RBNode(RBColor rBColor, X x, RBTree<X> rBTree, RBTree<X> rBTree2) {
        this.color = rBColor;
        this.data = x;
        this.left = rBTree;
        this.right = rBTree2;
    }

    public String toString() {
        return "(node " + this.color + " " + this.data + " " + this.left + " " + this.right + ")";
    }

    public boolean equals(Object object) {
        if (!(object instanceof RBNode)) {
            return false;
        }
        RBNode rBNode = (RBNode)object;
        return this.color.equals(rBNode.color) && this.data.equals(rBNode.data) && this.left.equals(rBNode.left) && this.right.equals(rBNode.right);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    boolean isBlack() {
        return this.color.isBlack();
    }

    @Override
    boolean isRed() {
        return this.color.isRed();
    }

    @Override
    RBNode<X> asNode() {
        return this;
    }

    @Override
    public boolean contains(X x, Comparator<X> comparator) {
        int n2 = comparator.compare(x, this.data);
        if (n2 < 0) {
            return this.left.contains(x, comparator);
        }
        if (n2 > 0) {
            return this.right.contains(x, comparator);
        }
        return true;
    }

    @Override
    public boolean containsAll(RBTree<X> rBTree, Comparator<X> comparator) {
        if (rBTree.isLeaf()) {
            return true;
        }
        RBNode<X> rBNode = rBTree.asNode();
        return this.contains(rBNode.data, comparator) && this.containsAll(rBNode.left, comparator) && this.containsAll(rBNode.right, comparator);
    }

    @Override
    public X find(X x, Comparator<X> comparator) {
        int n2 = comparator.compare(x, this.data);
        if (n2 < 0) {
            return this.left.find(x, comparator);
        }
        if (n2 > 0) {
            return this.right.find(x, comparator);
        }
        return this.data;
    }

    @Override
    public RBTree<X> remove(X x, Comparator<X> comparator) {
        return this.del(x, comparator).makeBlack();
    }

    @Override
    RBTree<X> del(X x, Comparator<X> comparator) {
        int n2 = comparator.compare(x, this.data);
        if (n2 < 0) {
            return this.left.isBlackNode() ? RBNode.balleft(this.left.del(x, comparator), this.data, this.right) : RBNode.node(RBNode.red(), this.data, this.left.del(x, comparator), this.right);
        }
        if (n2 > 0) {
            return this.right.isBlackNode() ? RBNode.balright(this.left, this.data, this.right.del(x, comparator)) : RBNode.node(RBNode.red(), this.data, this.left, this.right.del(x, comparator));
        }
        return RBNode.append(this.left, this.right);
    }

    @Override
    public List<X> toList() {
        return this.left.toList().append(this.right.toList().push(this.data));
    }

    @Override
    RBTree<X> makeBlack() {
        return RBNode.node(RBNode.black(), this.data, this.left, this.right);
    }

    @Override
    RBTree<X> makeRed() {
        return RBNode.node(RBNode.red(), this.data, this.left, this.right);
    }

    @Override
    public X pred() {
        return this.left.max();
    }

    @Override
    public X succ() {
        return this.right.min();
    }

    @Override
    public X min() {
        return this.left.isLeaf() ? this.data : this.left.min();
    }

    @Override
    public X max() {
        return this.right.isLeaf() ? this.data : this.right.min();
    }

    @Override
    RBTree<X> ins(X x, Comparator<X> comparator) {
        int n2 = comparator.compare(x, this.data);
        if (n2 == 0) {
            return this;
        }
        if (this.color.isBlack()) {
            if (n2 < 0) {
                return RBNode.balance(this.data, this.left.ins(x, comparator), this.right);
            }
            return RBNode.balance(this.data, this.left, this.right.ins(x, comparator));
        }
        if (n2 < 0) {
            return RBNode.node(RBNode.red(), this.data, this.left.ins(x, comparator), this.right);
        }
        return RBNode.node(RBNode.red(), this.data, this.left, this.right.ins(x, comparator));
    }

    @Override
    public RBTree<X> replace(X x, Comparator<X> comparator) {
        int n2 = comparator.compare(x, this.data);
        if (n2 == 0) {
            return RBNode.node(this.color, x, this.left, this.right);
        }
        if (n2 < 0) {
            return RBNode.node(this.color, this.data, this.left.replace(x, comparator), this.right);
        }
        return RBNode.node(this.color, this.data, this.left, this.right.replace(x, comparator));
    }

    public static class right
    extends Fields.any {
    }

    public static class left
    extends Fields.any {
    }

    public static class data
    extends Fields.any {
    }

    public static class color
    extends Fields.any {
    }
}

