/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.util;

import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.demfgen.lib.ident;
import edu.neu.ccs.demeterf.demfgen.lib.verbatim;
import edu.neu.ccs.demeterf.dispatch.DBEntry;
import edu.neu.ccs.demeterf.dispatch.MethodDB;
import edu.neu.ccs.demeterf.dispatch.indirect.Type;
import edu.neu.ccs.demeterf.util.Option;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    static boolean debugOn = false;
    public static boolean warningOn = false;
    public static boolean allowNull = false;
    public static boolean skipPrivate = true;
    public static HashSet<Class<?>> builtIns = new HashSet();
    public static Class<?>[] builtInArray;
    private static HashMap<Class<?>, List<Field>> memo;
    static HashMap<Class<?>, Class<?>> unboxed;
    static HashMap<Class<?>, Class<?>> boxed;
    public static int ARGS;
    public static int OPTS;

    private Util() {
    }

    public static boolean setDebug(boolean bl) {
        debugOn = bl;
        return debugOn;
    }

    public static boolean setWarning(boolean bl) {
        warningOn = bl;
        return warningOn;
    }

    public static boolean setAllowNull(boolean bl) {
        allowNull = bl;
        return allowNull;
    }

    public static boolean setSkipPrivate(boolean bl) {
        skipPrivate = bl;
        return skipPrivate;
    }

    public static void print(String string) {
        if (debugOn) {
            System.out.print(string);
        }
    }

    public static void println(String string) {
        Util.print(string + "\n");
    }

    public static void addBuiltIn(Class<?> clazz) {
        builtIns.add(clazz);
    }

    public static void addBuiltIns(Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            builtIns.add(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Field> getFuncFields(Class<?> clazz) {
        if (memo.containsKey(clazz)) {
            return memo.get(clazz);
        }
        HashMap<Class<?>, List<Field>> hashMap = memo;
        synchronized (hashMap) {
            Class<?> clazz2 = clazz;
            List<Field> list = List.create(new Field[0]);
            while (clazz != null && !clazz.isPrimitive()) {
                for (Field field : clazz.getDeclaredFields()) {
                    int n2 = field.getModifiers();
                    if (Modifier.isStatic(n2) || skipPrivate && Modifier.isPrivate(n2)) continue;
                    list = list.push(field);
                }
                clazz = clazz.getSuperclass();
            }
            list = list.reverse();
            memo.put(clazz2, list);
            return list;
        }
    }

    public static Object[] addArg(Object[] objectArray, Option option) {
        Object[] objectArray2 = objectArray;
        if (option.some()) {
            objectArray2 = new Object[objectArray.length + 1];
            for (int j = 0; j < objectArray.length; ++j) {
                objectArray2[j] = objectArray[j];
            }
            objectArray2[j] = option.get();
        }
        return objectArray2;
    }

    public static Object applyFObj(Object object, Object[] objectArray, MethodDB<Method> methodDB, String string, int n2) {
        Class<?>[] classArray = Util.classesFromObjects(objectArray, objectArray.length);
        DBEntry<Method> dBEntry = methodDB.matchEntryFast(classArray);
        if (dBEntry == null) {
            if (n2 < 0) {
                throw new RuntimeException("\n  DemeterF: Did Not Find a Match for: \n      " + Util.signature(object.getClass(), string, objectArray, objectArray.length) + "\n");
            }
            return objectArray[n2];
        }
        Method method = dBEntry.getMethod();
        Object object2 = n2 >= 0 ? objectArray[n2] : null;
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            object2 = method.invoke(object, Util.objectSubset(objectArray, method.getParameterTypes().length));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (!(invocationTargetException.getTargetException() instanceof RuntimeException)) {
                invocationTargetException.getTargetException().printStackTrace();
                throw new RuntimeException(invocationTargetException.getCause());
            }
            throw (RuntimeException)invocationTargetException.getCause();
        }
        return object2;
    }

    static void checkWarnMethods(List<DBEntry<Method>> list, Class<?> clazz) {
        if (!warningOn) {
            return;
        }
        DBEntry<Method> dBEntry = list.top();
        while (!(list = list.pop()).isEmpty()) {
            DBEntry<Method> dBEntry2 = list.top();
            if (dBEntry2.numArgs() >= dBEntry.numArgs() || dBEntry2.numArgs() <= 0 || !dBEntry.arg(0).isAssignableFrom(dBEntry2.arg(0)) || dBEntry.arg(0).equals(dBEntry2.arg(0))) continue;
            System.err.println("\n %% DemeterF Warning: A method with more arguments has been\n      chosen instead of one with a more specific first argument\n  function class: " + clazz.getSimpleName() + "\n" + "  * Chose : " + Util.dbEntrySig(dBEntry) + "\n" + "  *   Not : " + Util.dbEntrySig(dBEntry2) + "\n");
            return;
        }
    }

    static String dbEntrySig(DBEntry<?> dBEntry) {
        return dBEntry.toString();
    }

    public static Class<?>[] classesFromObjects(Object[] objectArray, int n2) {
        Class[] classArray = new Class[n2];
        for (int j = 0; j < n2; ++j) {
            if (objectArray[j] == null) {
                if (allowNull) {
                    classArray[j] = null;
                    continue;
                }
                Util.nullError();
                continue;
            }
            classArray[j] = objectArray[j].getClass();
        }
        return classArray;
    }

    public static Object[] objectSubset(Object[] objectArray, int n2) {
        if (objectArray.length == n2) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[n2];
        for (int j = 0; j < n2; ++j) {
            objectArray2[j] = objectArray[j];
        }
        return objectArray2;
    }

    public static String signature(Method method) {
        return Util.signature(method.getDeclaringClass(), method.getName(), method.getParameterTypes(), method.getParameterTypes().length);
    }

    public static String signature(Constructor<?> constructor) {
        return Util.signature(constructor.getDeclaringClass(), constructor.getDeclaringClass().getSimpleName(), constructor.getParameterTypes(), constructor.getParameterTypes().length);
    }

    public static String signature(Class<?> clazz, String string, Object[] objectArray, int n2) {
        return Util.signature(clazz, string, Util.classesFromObjects(objectArray, n2), n2);
    }

    public static String signature(Class<?> clazz, String string, Class<?>[] classArray, int n2) {
        String[] stringArray = new String[classArray.length];
        for (int j = 0; j < n2; ++j) {
            stringArray[j] = classArray[j].getSimpleName();
        }
        return Util.signature(clazz, string, stringArray, n2);
    }

    public static String signature(Class<?> clazz, String string, Type[] typeArray, int n2) {
        String[] stringArray = new String[typeArray.length];
        for (int j = 0; j < n2; ++j) {
            stringArray[j] = typeArray[j].getSimpleName();
        }
        return Util.signature(clazz, string, stringArray, n2);
    }

    public static String signature(Class<?> clazz, String string, String[] stringArray, int n2) {
        String string2 = clazz.getSimpleName() + "." + string + "(";
        for (int j = 0; j < n2; ++j) {
            string2 = string2 + (stringArray == null ? "null" : stringArray[j]);
            if (j >= n2 - 1) continue;
            string2 = string2 + ", ";
        }
        return string2 + ")";
    }

    public static void nullError() {
        throw new RuntimeException("\n  DemeterF: Null Object Found\n");
    }

    public static void nullFieldError(Field field) {
        throw new RuntimeException("\n  DemeterF: Null Field Found:  " + field.getDeclaringClass().getSimpleName() + "." + field.getName() + "\n");
    }

    public static Class<?> box(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return unboxed.get(clazz);
        }
        return clazz;
    }

    public static Class<?> unbox(Class<?> clazz) {
        if (boxed.containsKey(clazz)) {
            return boxed.get(clazz);
        }
        return clazz;
    }

    public static List<String>[] splitArgs(String[] stringArray) {
        List<Object> list = List.create(new Object[0]);
        List[] listArray = new List[]{list, list};
        for (String string : stringArray) {
            if (string.startsWith("-")) {
                listArray[Util.OPTS] = listArray[OPTS].push(string);
                continue;
            }
            listArray[Util.ARGS] = listArray[ARGS].push(string);
        }
        listArray[Util.ARGS] = listArray[ARGS].reverse();
        return listArray;
    }

    public static String[] separateOption(String string, List<String> list) {
        final String string2 = "--" + string + ":";
        int n2 = list.index(new List.Pred<String>(){

            @Override
            public boolean huh(String string) {
                return string.startsWith(string2);
            }
        });
        if (n2 >= 0) {
            return list.lookup(n2).substring(string2.length()).split(":");
        }
        return new String[0];
    }

    static {
        for (Class<?> clazz : builtInArray = new Class[]{Short.TYPE, Short.class, Integer.class, Integer.TYPE, Float.class, Float.TYPE, Long.class, Long.TYPE, Double.class, Double.TYPE, String.class, Boolean.class, Boolean.TYPE, Character.TYPE, Character.class, ident.class, verbatim.class}) {
            builtIns.add(clazz);
        }
        memo = new HashMap();
        unboxed = new HashMap();
        unboxed.put(Short.TYPE, Short.class);
        unboxed.put(Integer.TYPE, Integer.class);
        unboxed.put(Long.TYPE, Long.class);
        unboxed.put(Float.TYPE, Float.class);
        unboxed.put(Double.TYPE, Double.class);
        unboxed.put(Character.TYPE, Character.class);
        unboxed.put(Byte.TYPE, Byte.class);
        unboxed.put(Boolean.TYPE, Boolean.class);
        boxed = new HashMap();
        boxed.put(Short.class, Short.TYPE);
        boxed.put(Integer.class, Integer.TYPE);
        boxed.put(Long.class, Long.TYPE);
        boxed.put(Float.class, Float.TYPE);
        boxed.put(Double.class, Double.TYPE);
        boxed.put(Character.class, Character.TYPE);
        boxed.put(Byte.class, Byte.TYPE);
        boxed.put(Boolean.class, Boolean.TYPE);
        ARGS = 0;
        OPTS = 1;
    }
}

