/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.demfgen;

import edu.neu.ccs.demeterf.demfgen.Diff;

public class Preamble {
    public static String header = "// ** This class was generated with DemFGen (vers:" + Diff.buildDate + ")\n\n";
    public static String lexer = "SKIP : { \" \" | \"\\t\" | \"\\n\" | \"\\r\" | \"\\r\\n\" }\nSKIP : { <\"//\" (~[\"\\n\",\"\\r\"])* (\"\\n\"|\"\\r\\n\")> }\nSKIP : { <\"/*\" (~[\"*\"])* \"*\" (~[\"/\"] (~[\"*\"])* \"*\")* \"/\">}\nTOKEN: { < INT : (\"+\" | \"-\")?([\"0\"-\"9\"])+ > }\nTOKEN: { < STRING : \"\\\"\" (~[\"\\\"\"])* \"\\\"\" > }\nTOKEN: { < TRUE : \"true\" > }\nTOKEN: { < FALSE : \"false\" > }\nTOKEN: { < DOUBLE : (\"-\")?([\"0\"-\"9\"])+ \".\" ([\"0\"-\"9\"])+ | \".\" ([\"0\"-\"9\"])+ > }\nTOKEN: { < IDENT : [\"a\"-\"z\",\"A\"-\"Z\"] ([\"a\"-\"z\",\"A\"-\"Z\",\"0\"-\"9\",\"_\"])* > }\nTOKEN: { < TEXT : ( \"{{\" (~[\"}\"])* ( \"}\" ~[\"}\"] (~[\"}\"])* )* \"}}\" ) > }\nTOKEN: { < CHAR: \"\\'\" \n              ( (~[\"\\'\",\"\\\\\",\"\\n\",\"\\r\"]) | \n                (\"\\\\\" ( [\"n\",\"t\",\"b\",\"r\",\"f\",\"\\\\\",\"\\'\",\"\\\"\"] |\n                            [\"0\"-\"7\"] ( [\"0\"-\"7\"] )? |\n                            [\"0\"-\"3\"] [\"0\"-\"7\"] [\"0\"-\"7\"] ) ) )\n              \"\\'\" > }\n";
    public static String parserJava = "byte parse_byte():{ int i; }{\n    i = parse_int() { return (byte)i; }\n}\nByte parse_Byte():{ byte b; }{\n    b = parse_byte() { return b; }\n}\nshort parse_short():{ int i; }{\n    i = parse_int() { return (short)i; }\n}\nShort parse_Short():{ short s; }{\n    s = parse_short() { return s; }\n}\nint parse_int():{ Token t; }{\n    t = <INT>\n    { return Integer.parseInt(t.image); }\n}\nInteger parse_Integer():{ int i; }{\n    i = parse_int() { return i; }\n}\nlong parse_long():{ Token t; }{\n    t = <INT>\n    { return Long.parseLong(t.image); }\n}\nLong parse_Long():{ long l; }{\n    l = parse_long() { return l; }\n}\ndouble parse_double():{ Token t; }{\n    t = <DOUBLE>\n    { return Double.parseDouble(t.image); }\n}\nDouble parse_Double():{ double d; }{\n    d = parse_double() { return d; }\n}\nfloat parse_float():{ Token t; }{\n    t = <DOUBLE>\n    { return Float.parseFloat(t.image); }\n}\nFloat parse_Float():{ float f; }{\n    f = parse_float() { return f; }\n}\nString parse_String():{ Token t; }{\n    t = <STRING>\n    { return t.image.substring(1,t.image.length()-1); }\n}\nboolean parse_boolean():{ Token t; }{\n    t = <TRUE> { return true; } |\n    t = <FALSE> { return false; }\n}\nBoolean parse_Boolean():{ boolean b; }{\n    b = parse_boolean() { return b; }\n}\nchar parse_char():{ Token t; }{\n    t = <CHAR>\n    { return unescapeChar(t.image); }\n}\nCharacter parse_Character():{ char c; }{\n    c = parse_char() { return c; }\n}\nident parse_ident():{ Token t; }{\n    t = <IDENT>\n    { return new ident(t.image); }\n}\nverbatim parse_verbatim():{ Token t; }{\n    t = <TEXT>\n    { return new verbatim(t.image.substring(2,t.image.length()-2)); }\n}\n";
    public static String parserCS = "byte parse_byte():{ int i; }{\n    i = parse_int() { return (byte)i; }\n}\nByte parse_Byte():{ byte b; }{\n    b = parse_byte() { return b; }\n}\nshort parse_short():{ Token t; }{\n    t = <INT>\n    { return Int16.Parse(t.image); }\n}\nInt16 parse_Int16():{ short i; }{\n    i = parse_short() { return i; }\n}\nint parse_int():{ Token t; }{\n    t = <INT>\n    { return Int32.Parse(t.image); }\n}\nInt32 parse_Int32():{ int i; }{\n    i = parse_int() { return i; }\n}\nlong parse_long():{ Token t; }{\n    t = <INT>\n    { return Int64.Parse(t.image); }\n}\nInt64 parse_Int64():{ long l; }{\n    l = parse_long() { return l; }\n}\ndouble parse_double():{ Token t; }{\n    t = <DOUBLE>\n    { return Double.Parse(t.image); }\n}\nDouble parse_Double():{ double d; }{\n    d = parse_double() { return d; }\n}\nfloat parse_float():{ Token t; }{\n    t = <DOUBLE>\n    { return Single.Parse(t.image); }\n}\nSingle parse_Single():{ Single s; }{\n    s = parse_float() { return s; }\n}\nString parse_string():{ Token t; }{\n    t = <STRING>\n    { return t.image.Substring(1,t.image.Length-2); }\n}\nString parse_String():{ string s; }{\n    s = parse_string() { return s; }\n}\nbool parse_bool():{ Token t; }{\n    t = <TRUE> { return true; } |\n    t = <FALSE> { return false; }\n}\nBoolean parse_Boolean():{ bool b; }{\n    b = parse_bool() { return b; }\n}\nchar parse_char():{ Token t; }{\n    t = <CHAR>\n    { return unescapeChar(t.image); }\n}\nChar parse_Char():{ char c; }{\n    c = parse_char() { return c; }\n}\nident parse_ident():{ Token t; }{\n    t = <IDENT>\n    { return new ident(t.image); }\n}\nverbatim parse_verbatim():{ Token t; }{\n    t = <TEXT>\n    { return new verbatim(t.image.Substring(2,t.image.Length-2)); }\n}\n";
    public static String parserBodyCS = "\n    static char unescapeChar(String s){\n        s = s.Substring(1,s.Length-1);        char c = s[0];\n        if (c == '\\\\'){\n            switch (s[1]) {\n            case 'n': return '\\n';  case 't': return '\\t';\n            case 'b': return '\\b';  case 'r': return '\\r';\n            case 'f': return '\\f';  case '\\\\': return '\\\\';\n            case '\\'': return '\\''; case '\\\"': return '\\\"';\n            default: return (char)(Convert.ToInt32(s.Substring(1, s.Length), 8));\n            }\n        }\n        return c;\n    }\n";
    public static String parserBodyJava = "\n    static char unescapeChar(String s){\n        s = s.substring(1,s.length()-1);        char c = s.charAt(0);\n        if (c == '\\\\'){\n            switch (s.charAt(1)) {\n            case 'n': return '\\n';  case 't': return '\\t';\n            case 'b': return '\\b';  case 'r': return '\\r';\n            case 'f': return '\\f';  case '\\\\': return '\\\\';\n            case '\\'': return '\\''; case '\\\"': return '\\\"';\n            default: return (char)Integer.parseInt(s.substring(1, s.length()), 8);\n            }\n        }\n        return c;\n    }\n";
}

