/*
 * Decompiled with CFR 0.152.
 */
package admin.hidden;

import admin.hidden.TotalWeight;
import edu.neu.ccs.demeterf.demfgen.lib.Map;
import gen.Constraint;
import gen.RawMaterial;
import gen.RelationNr;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintCombiner {
    Map<RelationNr, Double> empty = Map.create(new RelationNrComp());
    Integer totalWeight;

    public static Map<RelationNr, Double> weightedRelations(RawMaterial rawMaterial) {
        Integer n = TotalWeight.totalWeight(rawMaterial);
        return ConstraintCombiner.traverse(rawMaterial, new ConstraintCombiner(n));
    }

    public static Map<RelationNr, Double> traverse(RawMaterial rawMaterial, ConstraintCombiner constraintCombiner) {
        Map<RelationNr, Double> map = constraintCombiner.empty;
        for (Constraint constraint : rawMaterial.instance.cs) {
            map = constraintCombiner.fold(map, constraintCombiner.combine(constraint));
        }
        return map;
    }

    public ConstraintCombiner(Integer n) {
        this.totalWeight = n;
    }

    public Map<RelationNr, Double> combine(Constraint constraint) {
        return this.empty.put(constraint.r, (double)constraint.w.v / (double)this.totalWeight.intValue());
    }

    public Map<RelationNr, Double> fold(Map<RelationNr, Double> map, Map<RelationNr, Double> map2) {
        return map.merge(map2, new Map.Merge<Double>(){

            @Override
            public Double merge(Double d, Double d2) {
                return d + d2;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RelationNrComp
    implements Comparator<RelationNr> {
        RelationNrComp() {
        }

        @Override
        public int compare(RelationNr relationNr, RelationNr relationNr2) {
            return relationNr.v - relationNr2.v;
        }
    }
}

