/*
 * Decompiled with CFR 0.152.
 */
package admin;

import admin.Administrator;
import admin.Output;
import admin.ProcessWatcher;
import admin.StreamWatcher;
import admin.Util;
import admin.utils.AccountUpdater;
import admin.utils.AdminDocumentHandler;
import admin.utils.Game;
import admin.utils.RuleChecker;
import admin.utils.StoreUpdater;
import config.AdminConfig;
import edu.neu.ccs.demeterf.demfgen.lib.Entry;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.demfgen.lib.Map;
import gen.Accounts;
import gen.Config;
import gen.Pair;
import gen.Player;
import gen.PlayerID;
import gen.PlayerTransaction;
import gen.Players;
import gen.Round;
import gen.Store;
import java.io.File;
import java.io.IOException;
import tournament.Result;
import tournament.Standing;
import tournament.Tournament;
import utils.comparator.LargerBalance;

public class TournAdmin
extends Administrator {
    public TournAdmin(Output output) {
        super(output);
    }

    public Result runMatch(Player player2, Player player3, Game.GameType gameType) {
        Object object;
        List<Object> list;
        TournAdmin tournAdmin = new TournAdmin(Output.htmlOutput());
        Config config = AdminDocumentHandler.getConfig();
        Store store = AdminDocumentHandler.getStore();
        Pair<PlayerID, Double> pair = new Pair<PlayerID, Double>(player2.id, config.Money);
        Pair<PlayerID, Double> pair2 = new Pair<PlayerID, Double>(player3.id, config.Money);
        List<Pair<PlayerID, Double>> list2 = List.create(new Pair[0]);
        list2 = list2.append(pair);
        list2 = list2.append(pair2);
        Accounts accounts2 = new Accounts(list2);
        AdminDocumentHandler.commitAccounts(accounts2);
        for (int i = 0; i < config.Rounds; ++i) {
            System.out.println("ROUND: " + i);
            list = List.create(new Object[0]);
            object = new Round(i, list);
            if (!this.passTurn(player2, config)) {
                return Result.black();
            }
            PlayerTransaction playerTransaction = AdminDocumentHandler.getPlayerTrans(player2);
            if (playerTransaction == null || !((Boolean)RuleChecker.rulesFollowed((PlayerTransaction)playerTransaction, (Store)store, (Accounts)accounts2, (Game.GameType)gameType).a).booleanValue()) {
                return Result.black();
            }
            playerTransaction = Util.computeQualities(playerTransaction);
            store = tournAdmin.updateStore(playerTransaction, store);
            accounts2 = tournAdmin.updateAccounts(playerTransaction, accounts2);
            if (!this.passTurn(player3, config)) {
                return Result.white();
            }
            PlayerTransaction playerTransaction2 = AdminDocumentHandler.getPlayerTrans(player3);
            if (playerTransaction2 == null || !((Boolean)RuleChecker.rulesFollowed((PlayerTransaction)playerTransaction2, (Store)store, (Accounts)accounts2, (Game.GameType)gameType).a).booleanValue()) {
                return Result.white();
            }
            playerTransaction2 = Util.computeQualities(playerTransaction2);
            store = tournAdmin.updateStore(playerTransaction2, store);
            accounts2 = tournAdmin.updateAccounts(playerTransaction2, accounts2);
            AdminDocumentHandler.updateHistory((Round)object);
        }
        Accounts accounts3 = AdminDocumentHandler.getAccounts();
        list = accounts3.accounts.sort(new LargerBalance());
        object = (PlayerID)list.top().a;
        if (((PlayerID)object).id == player2.id.id) {
            return Result.white();
        }
        return Result.black();
    }

    private Store updateStore(PlayerTransaction playerTransaction, Store store) {
        store = StoreUpdater.updateStore(store, playerTransaction);
        AdminDocumentHandler.commitStore(store);
        return store;
    }

    private Accounts updateAccounts(PlayerTransaction playerTransaction, Accounts accounts2) {
        accounts2 = AccountUpdater.updateAccounts(accounts2, playerTransaction);
        AdminDocumentHandler.commitAccounts(accounts2);
        return accounts2;
    }

    private boolean passTurn(Player player2, Config config) {
        String string;
        File file = new File("blackboard" + AdminConfig.PLAYERS_PATH);
        System.out.println("Player " + player2.id.id + " of team " + player2.name + "'s turn.");
        String string2 = "blackboard" + AdminConfig.PLAYERS_PATH + "/" + player2.name;
        String string3 = "java -Xss1M -jar " + player2.name + ".jar " + player2.id.id + " " + player2.name;
        String string4 = string2 + ".exe " + player2.id.id + " " + player2.name;
        File file2 = new File(string2 + ".jar");
        if (file2.exists()) {
            string = string3;
        } else {
            file2 = new File(string2 + ".exe");
            if (file2.exists()) {
                string = string4;
            } else {
                return false;
            }
        }
        Runtime runtime = Runtime.getRuntime();
        long l = 0L;
        long l2 = 0L;
        try {
            l = System.currentTimeMillis();
            Process process = runtime.exec(string, null, file);
            StreamWatcher streamWatcher = new StreamWatcher(process.getInputStream());
            StreamWatcher streamWatcher2 = new StreamWatcher(process.getErrorStream());
            ProcessWatcher processWatcher = new ProcessWatcher(process);
            Thread thread = new Thread(streamWatcher);
            Thread thread2 = new Thread(streamWatcher2);
            Thread thread3 = new Thread(processWatcher);
            thread.start();
            thread2.start();
            thread3.start();
            processWatcher.waitForTimeLimit(config.Time);
            l2 = System.currentTimeMillis();
            streamWatcher.done();
            streamWatcher2.done();
            System.out.println("Player " + player2.id.id + " of team " + player2.name + " finished in " + (l2 - l) + " milliseconds.");
            if (l2 - l > (long)config.Time) {
                process.destroy();
                System.out.println("Player " + player2.id.id + " kicked for time violation.");
                return false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return true;
    }

    public static void main(String[] stringArray) {
        Players players2 = AdminDocumentHandler.getPlayers();
        Tournament tournament = new Tournament(players2.players);
        tournament.runTournament();
        Map map = tournament.getResults();
        for (Entry entry : map) {
            System.out.println(((Player)entry.key).print() + " " + ((Standing)entry.val).print());
        }
    }
}

