/*
 * Decompiled with CFR 0.152.
 */
package gen;

import edu.neu.ccs.demeterf.control.Fields;
import gen.Derivative;
import gen.Display;
import gen.ParseException;
import gen.PrintHeap;
import gen.TheParser;
import gen.TransactionType;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

public class Transaction {
    public TransactionType ttype;
    public Derivative deriv;

    public Transaction(TransactionType transactionType, Derivative derivative) {
        this.ttype = transactionType;
        this.deriv = derivative;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Transaction)) {
            return false;
        }
        Transaction transaction = (Transaction)object;
        return this.ttype.equals(transaction.ttype) && ((Object)this.deriv).equals(transaction.deriv);
    }

    public static Transaction parse(String string) throws ParseException {
        return new TheParser(new StringReader(string)).parse_Transaction();
    }

    public static Transaction parse(InputStream inputStream) throws ParseException {
        return new TheParser(inputStream).parse_Transaction();
    }

    public static Transaction parse(Reader reader) throws ParseException {
        return new TheParser(reader).parse_Transaction();
    }

    public String printIter() {
        return "\ntrans[" + this.ttype.print() + " " + this.deriv.printIter() + "]";
    }

    public String display() {
        return Display.DisplayM(this);
    }

    public String print() {
        return PrintHeap.PrintHeapM(this);
    }

    public static class deriv
    extends Fields.any {
    }

    public static class ttype
    extends Fields.any {
    }
}

