/* **********************************
 *   Printer.java
 *     Printer
 ************************************/
package utils;

import gen.*;

public class Printer {
    
    // classic stuff
    public static String printIter(IntermediateProduct iP){
        return "(assignment:" + printIter(iP.assignment) + ")";
    }
    public static String printIter(RawMaterialInstance rmi){
        String result = "";
        for(Constraint c : rmi.cs)
            result += printIter(c);
        return result;
    }
    public static String printIter(Constraint c){
        String result = "\n";
        result += c.w.print() + c.r.print();
        for(Variable v : c.vs)
            result += v.print();
        return result;
    }
    public static String printIter(Assignment a){
        String result = "[";
        for(Literal l : a.literals)
            result += l.print();
        result += "]";
        return result;
    }
    
    // general stuff
    public static String printIter(Type t){
        String result = "type[";
        for(TypeInstance tI : t.instances)
            result += tI.print();
        return result + "]";
    }
    public static String printIter(Derivative d){
        String result = "deriv[";
        result += "\"" + d.name + "\" " + d.seller.print() + " ";
        result += (d.optbuyer.isSome() ? d.optbuyer.inner().print() : "");
        result += " " + d.price.print() + " " + d.type.print() + " ";
        result += (d.optraw.isSome() ? printIter(d.optraw.inner()) : "");
        result += " " + (d.optfinished.isSome() ? d.optfinished.inner().print() : "");
        return result + "]";
    }
    public static String printIter(RawMaterial rm){
        return "rm[" + printIter(rm.instance) + "]";
    }
    public static String printIter(FinishedProduct fP){
        return "finish[" + printIter(fP.ip) + " " + fP.quality.print() + "]";
    }
    public static String printIter(History h){
        String result = "history[\n";
        for(Round r : h.rounds)
            result += printIter(r);
        return result + "]";
    }
    public static String printIter(Round r){
        String result = "\nround " + r.num + " [";
        for(PlayerTransaction pTrans : r.ptransactions)
            result += printIter(pTrans);
        return result + "]";
    }
    public static String printIter(PlayerTransaction pT){
        String result = "ptrans[ player ";
        result += pT.player.print();
        for(Transaction t : pT.transactions)
        {
            result += printIter(t);
        }
        return result + "]";
    }
    public static String printIter(Transaction t){
        return "\ntrans[" + t.ttype.print() + " " + printIter(t.deriv) + "]";
    }
    public static String printIter(Store s){
        String result = "store[";
        for(Pair<PlayerID, PlayerStore> p : s.stores)
            result += p.a.print() + printIter(p.b);
        return result + "]";
    }
    public static String printIter(PlayerStore pS){
        String result = "pstore forsale ";
        for(Derivative d : pS.forSale)
            result += printIter(d);
        
        result += " bought ";
        for(Derivative d : pS.bought)
            result += printIter(d);
        return result;
    }
}
