package tournament;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

import edu.neu.ccs.demeterf.demfgen.lib.List;

import admin.Output;

public class TournHTMLOutput extends Output.HTML {

	public TournHTMLOutput(PrintStream ps) { super(ps); }
    public static TournHTMLOutput tournhtmlOutput(String file){
        try{ return new TournHTMLOutput(new PrintStream(new FileOutputStream(file)));
        }catch(IOException e){ return (TournHTMLOutput) die(file); }
    }
	
	public void finishTable(List<Standing> ls) 
	{
		println("\n<hr align='left' width='400px'><blockquote>\n"+wrap("***** Final Results! *****","h3"));
        String table = wrap(border("Place","td")+
        		border("Number","td")+
        		border("Team","td")+
        		border("Wins","td")+
        		border("Losses","td")+
        		border("Draws","td")
        		,"tr")+
        	ls.foldl(new List.Fold<Standing, String>(){
            int place = 0;
            public String fold(Standing s, String r)
            {
            	place++;
            	String pstr = place+wrap(superS[Math.min(3, place-1)], "sup");
            	return r + "     "+wrap(
            			border(pstr,"td")+
            			border("Player# "+s.player.id.print(),"td")+
            			border(s.player.name,"td")+
            			border(s.wins+"","td")+
            			border(s.losses+"","td")+
            			border(s.draws+"","td"),"tr");
            }}, "\n");
        println(border(table,"table")+"\n</blockquote>\n");
	}
}
