/* **********************************
 *   AdminDocumentHandler.java
 *     AdminDocumentHandler
 * **********************************/
package admin.utils;

import config.AdminConfig;
import config.GlobalConfig;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import gen.*;
import utils.*;

public class AdminDocumentHandler extends DocumentHandler{
    
    /** Reset the files in the blackboard directory to their default contents
     *    @author Greg Ayer, Alex Dubreuil */
    @SuppressWarnings("unchecked")
	public static void resetFilesToDefault(){
        final Config config = getConfig();
        
        // reset the history file to its default (empty history)
        write("history[ ", AdminConfig.BLACKBOARD_PATH+GlobalConfig.SEPAR+AdminConfig.HISTORY_FILE);

        // reset the store file to its default (empty store)
        commitStore(new Store(List.<Pair<PlayerID, PlayerStore>>create()));

        // reset the accounts file to its default (each player starts with config.Money)
        commitAccounts(new Accounts(
                getPlayers().players.map(
                        new List.Map<Player, Pair<PlayerID,Double>>(){
            public Pair<PlayerID,Double> map(Player p){
                return new Pair<PlayerID,Double>(p.id, config.Money);
            }})));
    }

    /** Writes the history */
    public static void commitHistory(History history) {
        String fileName = AdminConfig.HISTORY_FILE;
        write(history.printIter(), AdminConfig.BLACKBOARD_PATH+GlobalConfig.SEPAR+fileName);     
    }

    /** Writes a new Round to the history file */
    public static void updateHistory(Round round){
        String fileName = AdminConfig.HISTORY_FILE;
        write(round.print(), AdminConfig.BLACKBOARD_PATH+GlobalConfig.SEPAR+fileName, true);
    }

    /** "Closes" the history file to give it correct History syntax. */
    public static void closeHistory(){
        String fileName = AdminConfig.HISTORY_FILE;
        write("]", AdminConfig.BLACKBOARD_PATH+GlobalConfig.SEPAR+fileName, true);
    }

    /** Writes the accounts */
    public static void commitAccounts(Accounts accounts) {
        String fileName = AdminConfig.ACCOUNTS_FILE;
        write(accounts.print(),AdminConfig.BLACKBOARD_PATH+GlobalConfig.SEPAR+fileName);
    }

    /** Writes the store */
    public static void commitStore(Store store) {
        String fileName = AdminConfig.STORE_FILE;
        write(store.print(),AdminConfig.BLACKBOARD_PATH+GlobalConfig.SEPAR+fileName);
    }
    
    public static Accounts getAccounts(){ return DocumentHandler.getAccounts(AdminConfig.BLACKBOARD_PATH); }
    public static Store getStore(){ return DocumentHandler.getStore(AdminConfig.BLACKBOARD_PATH); }
    public static History getHistory(){ return DocumentHandler.getHistory(AdminConfig.BLACKBOARD_PATH); }
    public static PlayerTransaction getPlayerTrans(Player player){ return DocumentHandler.getPlayerTrans(player, AdminConfig.BLACKBOARD_PATH); }    
    public static void deletePlayerTrans(Player player){ DocumentHandler.deletePlayerTrans(player, AdminConfig.BLACKBOARD_PATH);
    	
    }
    
    public static Players getPlayers(){ return DocumentHandler.getPlayers(AdminConfig.BLACKBOARD_ADMIN_PATH); }
    public static Config getConfig(){ return DocumentHandler.getConfig(AdminConfig.BLACKBOARD_ADMIN_PATH); }
}
