package admin.utils;

import config.GlobalConfig;
import admin.utils.Game.GameType;

public class AdminCmdLineParser 
{
	public GameType gt;
	public String outputFile;
	public String resultsFile;
	public String maxStack;
	
	public AdminCmdLineParser(String[] args)
	{
		int i = 0;
		gt = null;
		outputFile = "";
		resultsFile = "";
		maxStack = "";
		while(i < args.length){
			if(args[i].equals("-gt") && i < args.length - 1){
				i++;
				if(args[i].equals("tball")) { gt = GameType.TBALL; }
				else if(args[i].equals("slowpitch")) { gt = GameType.SLOWPITCH; }
				else if(args[i].equals("fastpitch2")) { gt = GameType.FASTPITCH2; }
				else if(args[i].equals("fastpitch")) { gt = GameType.FASTPITCH; }
				else if(args[i].equals("baseball")) { gt = GameType.BASEBALL; }
				else { printErrorMessage(); }
			}else if(args[i].equals("-o") && i < args.length - 1){
				i++;
				outputFile = args[i];
			}else if(args[i].equals("-r")  && i < args.length - 1){
				i++;
				resultsFile = args[i];
			}else if(args[i].equals("-pstack") && i < args.length - 1){
				i++;
				maxStack = args[i];
			}else{
				printErrorMessage();
			}
			i++;
		}
		if(gt == null){ printErrorMessage(); }
		if(maxStack.equals("")) { maxStack = GlobalConfig.DEFAULT_MAX_STACK; }
	}
	
	public void printErrorMessage()
	{
		System.err.println(" ** Usage: java -jar admin.jar [modifiers]\n"+
        		"   Modifiers: \n"+
        		"   -gt [type]: Run a specific GameType (required)\n"+
        		"     - GameType: one of tball, slowpitch, fastpitch2, fastpitch, baseball\n"+
        		"   -o [fileName]\n"+
                "     - Run the administrator with output to the given file (optional).\n"+
                "     - If no file is given, StdErr is used.\n"+
                "   -r [fileName]\n"+
                "     - Run the administrator with results to the given file (optional).\n"+
                "     - Results will otherwise be sent to the -o location.\n"+
                "   -pstack [stack]\n"+
                "     - Run players with the given stack size (Java formatting, eg, 1M).\n");
        System.exit(1);
	}
}
