/* **********************************
 *   ProcessWatcher.java
 *     ProcessWatcher
 * **********************************/
package admin;

/** Waits for a Process to complete, but only for a set amount of time */
public class ProcessWatcher extends Thread{
    Process proc;
    public ProcessWatcher(Process p){ proc = p; start(); }
    
    /** Wait for the time to be up... Called by some other thread*/
    public synchronized void waitForTimeLimit(int time) throws InterruptedException{ wait(time); }
    
    /** Wait for the process to finish */
    public void run(){
        try{ proc.waitFor(); } 
        catch(InterruptedException e){ e.printStackTrace(); }
        synchronized(this){ notifyAll(); }
    }
}
