package edu.neu.ccs.satsolver;

import java.util.Set;

/**
 * After the first input from the csu team, all future calls
 * to the outsourcing team code will be through InputUpdateI class
 * instances.
 */
public interface InputUpdateI {
    /**
     * Returns the polynomial to perform the modifications to.
     * 
     * @return The previously generated polynomial
     * 
     * @see edu.neu.ccs.satsolver.PolynomialI
     * 
     */
    public PolynomialI getPolynomialBefore();
    
    /**
     * Returns the pairs that have been added since the last Input.
     * <p>
     * No two pairs in the set should have the same relation number.
     *
     * @return the set of added pairs
     */
    public Set getAddedPairs();
    
    /**
     * Returns the pairs that have been removed since the last Input.
     * <p>
     * No two pairs in the set should have the same relation number.
     *
     * @return the set of subtracted pairs
     */
    public Set getSubtractedPairs();
}



