/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.dispatch.indirect;

import edu.neu.ccs.demeterf.Bc;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.dispatch.indirect.DBEntry;
import edu.neu.ccs.demeterf.dispatch.indirect.Type;
import edu.neu.ccs.demeterf.dispatch.indirect.TypeSort;
import edu.neu.ccs.demeterf.dispatch.indirect.TypedEntry;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDB<M> {
    private List<DBEntry<M>> methods;

    public static List<DBEntry<Type>> getMethods(Class<?> clazz, String string, List<DBEntry<Type>> list) {
        List<DBEntry<Type>> list2 = List.create(new DBEntry[0]);
        while (clazz != null && !clazz.equals(Object.class)) {
            if (!clazz.equals(Bc.class)) {
                for (Method method : clazz.getDeclaredMethods()) {
                    TypedEntry typedEntry;
                    if (!method.getName().equals(string) || list2.contains(typedEntry = new TypedEntry(method))) continue;
                    list2 = list2.push(typedEntry);
                }
            } else {
                for (DBEntry dBEntry : list) {
                    if (list2.contains(dBEntry)) continue;
                    list2 = list2.push(dBEntry);
                }
            }
            clazz = clazz.getSuperclass();
        }
        return list2;
    }

    public static MethodDB<Type> createMethodDB(Class<?> clazz, String string, List<DBEntry<Type>> list) {
        return new MethodDB<Type>(MethodDB.getMethods(clazz, string, list));
    }

    public MethodDB(List<DBEntry<M>> list) {
        this.methods = list;
    }

    public DBEntry<M> matchEntryFast(Type[] typeArray) {
        return MethodDB.matchEntryFast(typeArray, typeArray.length, this.methods);
    }

    private static <M> DBEntry<M> matchEntryFast(Type[] typeArray, int n2, List<DBEntry<M>> list) {
        if (list.isEmpty()) {
            return null;
        }
        DBEntry<M> dBEntry = list.top();
        if (MethodDB.applicable(typeArray, n2, dBEntry)) {
            return MethodDB.matchEntryFast(typeArray, n2, list.pop(), dBEntry);
        }
        return MethodDB.matchEntryFast(typeArray, n2, list.pop());
    }

    private static <M> boolean applicable(Type[] typeArray, int n2, DBEntry<M> dBEntry) {
        if (dBEntry.numArgs() > n2) {
            return false;
        }
        for (int j = 0; j < dBEntry.numArgs(); ++j) {
            if (dBEntry.arg(j).isAssignableFrom(typeArray[j])) continue;
            return false;
        }
        return true;
    }

    private static <M> DBEntry<M> matchEntryFast(Type[] typeArray, int n2, List<DBEntry<M>> list, DBEntry<M> dBEntry) {
        if (list.isEmpty()) {
            return dBEntry;
        }
        DBEntry<M> dBEntry2 = list.top();
        if (MethodDB.applicable(typeArray, n2, dBEntry2) && TypeSort.compare(dBEntry2, dBEntry)) {
            return MethodDB.matchEntryFast(typeArray, n2, list.pop(), dBEntry2);
        }
        return MethodDB.matchEntryFast(typeArray, n2, list.pop(), dBEntry);
    }

    public M match(Type[] typeArray) {
        DBEntry<M> dBEntry = this.matchEntryFast(typeArray);
        return dBEntry != null ? (M)dBEntry.getMethod() : null;
    }

    public List<DBEntry<M>> matchAll(final Type[] typeArray) {
        return this.methods.filter(new List.Pred<DBEntry<M>>(){

            @Override
            public boolean huh(DBEntry<M> dBEntry) {
                return MethodDB.applicable(typeArray, typeArray.length, dBEntry);
            }
        });
    }

    public String toString() {
        return this.methods.toString();
    }

    public String toString(String string) {
        return this.methods.toString(string, "");
    }

    public List<DBEntry<M>> prefixApp(final Class<?> clazz) {
        return this.methods.filter(new List.Pred<DBEntry<M>>(){

            @Override
            public boolean huh(DBEntry<M> dBEntry) {
                return dBEntry.numArgs() >= 1 && dBEntry.arg(0).isAssignableFrom(clazz);
            }
        });
    }
}

