/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.demfgen.lib;

import edu.neu.ccs.demeterf.Control;
import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.Traversal;
import edu.neu.ccs.demeterf.control.Edge;
import edu.neu.ccs.demeterf.demfgen.lib.Cons;
import edu.neu.ccs.demeterf.demfgen.lib.Empty;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.demfgen.lib.RBColor;
import edu.neu.ccs.demeterf.demfgen.lib.RBLeaf;
import edu.neu.ccs.demeterf.demfgen.lib.RBNode;
import java.util.Comparator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RBTree<X extends Comparable<X>>
implements Iterable<X> {
    public abstract boolean isLeaf();

    public RBTree<X> insert(X x) {
        return this.insert(x, new CComp());
    }

    public RBTree<X> insert(X x, Comparator<X> comparator) {
        return this.ins(x, comparator).makeBlack();
    }

    public RBTree<X> insertAll(RBTree<X> rBTree) {
        return this.insertAll(rBTree.toList());
    }

    public RBTree<X> insertAll(List<X> list) {
        return this.insertAll(list, new CComp());
    }

    public RBTree<X> insertAll(RBTree<X> rBTree, Comparator<X> comparator) {
        return this.insertAll(rBTree.toList(), comparator);
    }

    public RBTree<X> insertAll(List<X> list, Comparator<X> comparator) {
        if (list.isEmpty()) {
            return this;
        }
        return this.insert((Comparable)list.top(), comparator).insertAll(list.pop(), comparator);
    }

    public RBTree<X> remove(X x) {
        return this.remove(x, new CComp());
    }

    public abstract RBTree<X> remove(X var1, Comparator<X> var2);

    abstract RBTree<X> del(X var1, Comparator<X> var2);

    abstract boolean isBlack();

    abstract boolean isRed();

    abstract RBNode<X> asNode();

    abstract RBTree<X> makeBlack();

    abstract RBTree<X> makeRed();

    abstract RBTree<X> ins(X var1, Comparator<X> var2);

    public abstract X pred();

    public abstract X succ();

    public abstract X min();

    public abstract X max();

    boolean isBlackNode() {
        return !this.isLeaf() && this.isBlack();
    }

    boolean isRedNode() {
        return !this.isLeaf() && this.isRed();
    }

    public boolean contains(X x) {
        return this.contains(x, new CComp());
    }

    public abstract boolean contains(X var1, Comparator<X> var2);

    public boolean containsAll(RBTree<X> rBTree) {
        return this.containsAll(rBTree, new CComp());
    }

    public abstract boolean containsAll(RBTree<X> var1, Comparator<X> var2);

    public X find(X x) {
        return this.find(x, new CComp());
    }

    public abstract X find(X var1, Comparator<X> var2);

    public RBTree<X> replace(X x) {
        return this.replace(x, new CComp());
    }

    public abstract RBTree<X> replace(X var1, Comparator<X> var2);

    public abstract List<X> toList();

    static <X extends Comparable<X>> RBTree<X> balance(X x, RBTree<X> rBTree, RBTree<X> rBTree2) {
        RBNode<X> rBNode;
        if (rBTree.isRedNode() && rBTree2.isRedNode()) {
            return RBTree.node(RBTree.red(), x, rBTree.makeBlack(), rBTree2.makeBlack());
        }
        if (rBTree.isRedNode()) {
            rBNode = rBTree.asNode();
            if (rBNode.left.isRedNode()) {
                RBNode rBNode2 = rBNode.left.asNode();
                return RBTree.node(RBTree.red(), rBNode.data, RBTree.node(RBTree.black(), rBNode2.data, rBNode2.left, rBNode2.right), RBTree.node(RBTree.black(), x, rBNode.right, rBTree2));
            }
            if (rBNode.right.isRedNode()) {
                RBNode rBNode3 = rBNode.right.asNode();
                return RBTree.node(RBTree.red(), rBNode3.data, RBTree.node(RBTree.black(), rBNode.data, rBNode.left, rBNode3.left), RBTree.node(RBTree.black(), x, rBNode3.right, rBTree2));
            }
        }
        if (rBTree2.isRedNode()) {
            rBNode = rBTree2.asNode();
            if (rBNode.left.isRedNode()) {
                RBNode rBNode4 = rBNode.left.asNode();
                return RBTree.node(RBTree.red(), rBNode4.data, RBTree.node(RBTree.black(), x, rBTree, rBNode4.left), RBTree.node(RBTree.black(), rBNode.data, rBNode4.right, rBNode.right));
            }
            if (rBNode.right.isRedNode()) {
                RBNode rBNode5 = rBNode.right.asNode();
                return RBTree.node(RBTree.red(), rBNode.data, RBTree.node(RBTree.black(), x, rBTree, rBNode.left), RBTree.node(RBTree.black(), rBNode5.data, rBNode5.left, rBNode5.right));
            }
        }
        return RBTree.node(RBTree.black(), x, rBTree, rBTree2);
    }

    protected static <X extends Comparable<X>> RBTree<X> balleft(RBTree<X> rBTree, X x, RBTree<X> rBTree2) {
        if (rBTree.isRedNode()) {
            return RBTree.node(RBTree.red(), x, rBTree.makeBlack(), rBTree2);
        }
        if (rBTree2.isBlackNode()) {
            return RBTree.balance(x, rBTree, rBTree2.makeRed());
        }
        RBNode<X> rBNode = rBTree2.asNode();
        RBNode rBNode2 = rBNode.left.asNode();
        return RBTree.node(RBTree.red(), rBNode2.data, RBTree.node(RBTree.black(), x, rBTree, rBNode2.left), RBTree.balance(rBNode.data, rBNode2.right, rBNode.right.makeRed()));
    }

    protected static <X extends Comparable<X>> RBTree<X> balright(RBTree<X> rBTree, X x, RBTree<X> rBTree2) {
        if (rBTree2.isRedNode()) {
            return RBTree.node(RBTree.red(), x, rBTree, rBTree2.makeBlack());
        }
        if (rBTree.isBlackNode()) {
            return RBTree.balance(x, rBTree.makeRed(), rBTree2);
        }
        RBNode<X> rBNode = rBTree.asNode();
        RBNode rBNode2 = rBNode.right.asNode();
        return RBTree.node(RBTree.red(), rBNode2.data, RBTree.balance(rBNode.data, rBNode.left.makeRed(), rBNode2.left), RBTree.node(RBTree.black(), x, rBNode2.right, rBTree2));
    }

    protected static <X extends Comparable<X>> RBTree<X> append(RBTree<X> rBTree, RBTree<X> rBTree2) {
        if (rBTree.isLeaf()) {
            return rBTree2;
        }
        if (rBTree2.isLeaf()) {
            return rBTree;
        }
        RBNode<X> rBNode = rBTree.asNode();
        RBNode<X> rBNode2 = rBTree2.asNode();
        if (rBNode.color.equals(rBNode2.color)) {
            RBColor rBColor = rBNode.color;
            RBTree rBTree3 = RBTree.append(rBNode.right, rBNode2.left);
            if (rBTree3.isRedNode()) {
                RBNode rBNode3 = rBTree3.asNode();
                return RBTree.node(RBTree.red(), rBNode3.data, RBTree.node(rBColor, rBNode.data, rBNode.left, rBNode3.left), RBTree.node(rBColor, rBNode2.data, rBNode3.right, rBNode2.right));
            }
            if (rBColor.isRed()) {
                return RBTree.node(RBTree.red(), rBNode.data, rBNode.left, RBTree.node(RBTree.red(), rBNode2.data, rBTree3, rBNode2.right));
            }
            return RBTree.balleft(rBNode.left, rBNode.data, RBTree.node(RBTree.black(), rBNode2.data, rBTree3, rBNode2.right));
        }
        if (rBNode2.isRed()) {
            return RBTree.node(RBTree.red(), rBNode2.data, RBTree.append(rBNode, rBNode2.left), rBNode2.right);
        }
        return RBTree.node(RBTree.red(), rBNode.data, rBNode.left, RBTree.append(rBNode.right, rBNode2));
    }

    public static RBColor black() {
        return RBColor.black();
    }

    public static RBColor red() {
        return RBColor.red();
    }

    public static <X extends Comparable<X>> RBTree<X> create(X ... XArray) {
        RBTree rBTree = new RBLeaf<X>();
        for (X x : XArray) {
            rBTree = rBTree.insert(x);
        }
        return rBTree;
    }

    public static <X extends Comparable<X>> RBTree<X> create(List<X> list) {
        return (RBTree)new Traversal(new ID(){

            RBTree<X> combine(Empty<X> empty) {
                return new RBLeaf();
            }

            RBTree<X> combine(Cons cons, X x, RBTree<X> rBTree) {
                return rBTree.insert(x);
            }
        }, (Control)Control.bypass(new Edge(Cons.class, "first"))).traverse(list);
    }

    public static <X extends Comparable<X>> RBLeaf<X> leaf() {
        return new RBLeaf();
    }

    public static <X extends Comparable<X>> RBNode<X> node(RBColor rBColor, X x, RBTree<X> rBTree, RBTree<X> rBTree2) {
        return new RBNode<X>(rBColor, x, rBTree, rBTree2);
    }

    @Override
    public Iterator<X> iterator() {
        return this.toList().iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CComp<X extends Comparable<X>>
    implements Comparator<X> {
        CComp() {
        }

        @Override
        public int compare(X x, X x2) {
            return x.compareTo(x2);
        }
    }
}

