/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.evergreen.ir;

import edu.neu.ccs.evergreen.ir.RelationNumberUtil;

public class RelationCore {
    public static final int SOURCE = 0;
    public static final int TARGET = 1;
    public static final int MaxRank = 5;

    public static int getMagicNumber(int rank, int variablePosition, int value) throws IllegalArgumentException {
        RelationCore.checkRank(rank);
        RelationCore.checkVariablePosition(variablePosition, rank);
        RelationCore.checkValue(value);
        int[] MagicNumbers = new int[]{0x55555555, 0x33333333, 0xF0F0F0F, 0xFF00FF, 65535};
        int mask = RelationCore.getMask(rank);
        int maskedColumn = MagicNumbers[variablePosition] & mask;
        int returnval = value == 1 ? mask ^ maskedColumn : maskedColumn;
        return returnval;
    }

    public static int getMask(int rank) {
        RelationCore.checkRank(rank);
        int[] mask = new int[]{1, 3, 15, 255, 65535, -1};
        return mask[rank];
    }

    public static boolean isIrrelevant(int relationNumber, int rank, int variablePosition) {
        RelationCore.checkRank(rank);
        RelationCore.checkRelationNumber(relationNumber, rank);
        RelationCore.checkVariablePosition(variablePosition, rank);
        int m = RelationCore.getMagicNumber(rank, variablePosition, 1);
        return (relationNumber & m) >>> (1 << variablePosition) == (relationNumber & ~m);
    }

    public static int numberOfRelevantVariables(int relationNumber, int rank) {
        RelationCore.checkRank(rank);
        RelationCore.checkRelationNumber(relationNumber, rank);
        int relevantVariables = rank;
        int variablePosition = 0;
        while (variablePosition < rank) {
            if (RelationCore.isIrrelevant(relationNumber, rank, variablePosition)) {
                --relevantVariables;
            }
            ++variablePosition;
        }
        return relevantVariables;
    }

    public static int isForced(int relationNumber, int rank, int variablePosition) {
        RelationCore.checkRank(rank);
        RelationCore.checkRelationNumber(relationNumber, rank);
        RelationCore.checkVariablePosition(variablePosition, rank);
        if (RelationCore.isIrrelevant(relationNumber, rank, variablePosition)) {
            return -1;
        }
        int m = RelationCore.getMagicNumber(rank, variablePosition, 1);
        int rm = relationNumber & m;
        if (rm == 0) {
            return 0;
        }
        if (rm == relationNumber) {
            return 1;
        }
        return -1;
    }

    public static int firstForcedVariable(int relationNumber, int rank, int startPosition) {
        RelationCore.checkRank(rank);
        RelationCore.checkRelationNumber(relationNumber, rank);
        RelationCore.checkVariablePosition(startPosition, rank);
        int forcedVarPos = -1;
        int variablePosition = startPosition;
        while (variablePosition < rank) {
            if (RelationCore.isForced(relationNumber, rank, variablePosition) != -1) {
                forcedVarPos = variablePosition;
                break;
            }
            ++variablePosition;
        }
        return forcedVarPos;
    }

    public static int nMap(int relationNumber, int rank, int variablePosition) {
        RelationCore.checkRank(rank);
        RelationCore.checkRelationNumber(relationNumber, rank);
        RelationCore.checkVariablePosition(variablePosition, rank);
        int m0 = RelationCore.getMagicNumber(rank, variablePosition, 0);
        int m1 = RelationCore.getMagicNumber(rank, variablePosition, 1);
        int s = 1 << variablePosition;
        int r = (relationNumber & m0) << s | (relationNumber & m1) >>> s;
        return r;
    }

    public static int reduce(int relationNumber, int rank, int variablePosition, int value) {
        RelationCore.checkRank(rank);
        RelationCore.checkRelationNumber(relationNumber, rank);
        RelationCore.checkVariablePosition(variablePosition, rank);
        RelationCore.checkValue(value);
        int m = RelationCore.getMagicNumber(rank, variablePosition, value);
        int rm = relationNumber & m;
        rm = value == 0 ? (rm |= rm << (1 << variablePosition)) : (rm |= rm >>> (1 << variablePosition));
        return rm;
    }

    public static int swap(int relationNumber, int rank, int variablePosition1, int variablePosition2) {
        RelationCore.checkRank(rank);
        RelationCore.checkRelationNumber(relationNumber, rank);
        RelationCore.checkVariablePosition(variablePosition1, rank);
        RelationCore.checkVariablePosition(variablePosition1, rank);
        if (variablePosition1 == variablePosition2) {
            return relationNumber;
        }
        if (variablePosition1 > variablePosition2) {
            int tmp = variablePosition1;
            variablePosition1 = variablePosition2;
            variablePosition2 = tmp;
        }
        int d10 = RelationCore.getMagicNumber(rank, variablePosition1, 0);
        int d11 = RelationCore.getMagicNumber(rank, variablePosition1, 1);
        int d20 = RelationCore.getMagicNumber(rank, variablePosition2, 0);
        int d21 = RelationCore.getMagicNumber(rank, variablePosition2, 1);
        int same_filter = d11 & d21 | d10 & d20;
        int up_filter = d21 & d10;
        int dn_filter = d20 & d11;
        int shift_amt = (1 << variablePosition2) - (1 << variablePosition1);
        int s = relationNumber & same_filter;
        int u = relationNumber & up_filter;
        int d = relationNumber & dn_filter;
        return s | d << shift_amt | u >>> shift_amt;
    }

    public static int renme(int relationNumber, int rank, int permutationSemantics, int ... permutation) {
        RelationCore.checkRank(rank);
        RelationCore.checkRelationNumber(relationNumber, rank);
        RelationCore.checkPermutation(rank, permutation);
        RelationCore.checkPermutationSemantics(permutationSemantics);
        int out = 0;
        while (out < rank - 1) {
            int min = out;
            int in = out + 1;
            while (in < rank) {
                if (permutation[in] < permutation[min]) {
                    min = in;
                }
                ++in;
            }
            int tmp = permutation[out];
            permutation[out] = permutation[min];
            permutation[min] = tmp;
            switch (permutationSemantics) {
                case 0: {
                    relationNumber = RelationCore.swap(relationNumber, rank, permutation[min], permutation[out]);
                    break;
                }
                case 1: {
                    relationNumber = RelationCore.swap(relationNumber, rank, min, out);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Internal Error: Unsupported semantics" + permutationSemantics);
                }
            }
            ++out;
        }
        return relationNumber;
    }

    public static int ones(int relationNumber, int rank) {
        RelationCore.checkRank(rank);
        RelationCore.checkRelationNumber(relationNumber, rank);
        int c = 0;
        int i = 0;
        while (i < 1 << rank) {
            if ((relationNumber & 1 << i) != 0) {
                ++c;
            }
            ++i;
        }
        return c;
    }

    public static int q(int relationNumber, int rank, int numberOfTrueVars) {
        RelationCore.checkRank(rank);
        RelationCore.checkRelationNumber(relationNumber, rank);
        if (numberOfTrueVars > rank) {
            throw new IllegalArgumentException("A relation of rank " + rank + " can have up to " + rank + " true vars");
        }
        int m = RelationNumberUtil.xTrueVars(rank, numberOfTrueVars);
        return RelationCore.ones(relationNumber & m, rank);
    }

    public static void checkRelationNumber(int relationNumber, int rank) throws IllegalArgumentException {
        int upperbound = RelationCore.getMask(rank);
        if ((relationNumber & ~upperbound) != 0) {
            throw new IllegalArgumentException("RelationNumber " + relationNumber + " out of range for rank " + rank);
        }
    }

    public static void checkVariablePosition(int variablePosition, int rank) throws IllegalArgumentException {
        if (variablePosition < 0 || variablePosition >= rank) {
            throw new IllegalArgumentException("Variable Position " + variablePosition + " is invalid for relations of rank " + rank);
        }
    }

    public static void checkValue(int value) throws IllegalArgumentException {
        if (value < 0 || value > 1) {
            throw new IllegalArgumentException("Variables can only be either 0 or 1. recieved " + value);
        }
    }

    public static void checkRank(int rank) throws IllegalArgumentException {
        if (rank < 1 || rank > 5) {
            throw new IllegalArgumentException("Supported ranks are within [1,5]. Sent rank " + rank);
        }
    }

    public static void checkPermutation(int rank, int ... permutation) throws IllegalArgumentException {
        if (permutation.length != rank) {
            throw new IllegalArgumentException("Invalid Permutation: incorrect number of variable positions");
        }
        int[] positions = new int[rank];
        int i = 0;
        while (i < rank) {
            positions[i] = 0;
            ++i;
        }
        int[] nArray = permutation;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int variablePosition = nArray[n];
            RelationCore.checkVariablePosition(variablePosition, rank);
            if (positions[variablePosition] != 0) {
                throw new IllegalArgumentException("Invalid Permutation: position " + variablePosition + " repeated");
            }
            int n3 = variablePosition;
            positions[n3] = positions[n3] + 1;
            ++n;
        }
    }

    public static void checkPermutationSemantics(int permutationSemantics) throws IllegalArgumentException {
        if (permutationSemantics != 0 && permutationSemantics != 1) {
            throw new IllegalArgumentException("Illegal permutation semantics. Should be either RelationCore.SOURCE or RelationCore.TARGET");
        }
    }
}

