/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.evergreen.ir;

import edu.neu.ccs.evergreen.ir.RelationCore;
import org.junit.Assert;
import org.junit.Test;

public class RelationCoreIrrelevantVariables {
    int maxRank = 5;

    @Test
    public final void testIsIrrelevant() {
        int variablePosition;
        int rank = 1;
        while (rank <= this.maxRank) {
            variablePosition = 0;
            while (variablePosition < rank) {
                int value = 0;
                while (value <= 1) {
                    int relationNumber = RelationCore.getMagicNumber(rank, variablePosition, value);
                    int otherVariablePosition = 0;
                    while (otherVariablePosition < rank) {
                        if (otherVariablePosition != variablePosition) {
                            Assert.assertTrue((boolean)RelationCore.isIrrelevant(relationNumber, rank, otherVariablePosition));
                        }
                        ++otherVariablePosition;
                    }
                    ++value;
                }
                ++variablePosition;
            }
            ++rank;
        }
        rank = 1;
        while (rank <= this.maxRank) {
            variablePosition = 0;
            while (variablePosition < rank) {
                int r1 = 0;
                int r2 = RelationCore.getMask(rank);
                Assert.assertTrue((boolean)RelationCore.isIrrelevant(r1, rank, variablePosition));
                Assert.assertTrue((boolean)RelationCore.isIrrelevant(r2, rank, variablePosition));
                ++variablePosition;
            }
            ++rank;
        }
    }

    @Test
    public final void testNumberOfRelevantVariables() {
        int rank = 1;
        while (rank <= this.maxRank) {
            int variablePosition = 0;
            while (variablePosition < rank) {
                int value = 0;
                while (value <= 1) {
                    int relationNumber = RelationCore.getMagicNumber(rank, variablePosition, value);
                    Assert.assertTrue((RelationCore.numberOfRelevantVariables(relationNumber, rank) == 1 ? 1 : 0) != 0);
                    ++value;
                }
                ++variablePosition;
            }
            ++rank;
        }
        rank = 1;
        while (rank <= this.maxRank) {
            int r1 = 0;
            int r2 = RelationCore.getMask(rank);
            Assert.assertTrue((RelationCore.numberOfRelevantVariables(r1, rank) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((RelationCore.numberOfRelevantVariables(r2, rank) == 0 ? 1 : 0) != 0);
            ++rank;
        }
    }
}

