/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.dispatch;

import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.dispatch.ConstrEntry;
import edu.neu.ccs.demeterf.dispatch.DBEntry;
import edu.neu.ccs.demeterf.dispatch.MethodEntry;
import edu.neu.ccs.demeterf.dispatch.TypeSort;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDB<M> {
    static boolean debug = false;
    protected List<DBEntry<M>> methods;

    public MethodDB(List<DBEntry<M>> list) {
        this.methods = list;
    }

    public static List<DBEntry<Method>> getMethods(Class<?> clazz, String string) {
        List<DBEntry<Method>> list = List.create(new DBEntry[0]);
        while (clazz != null && !clazz.equals(Object.class)) {
            for (Method method : clazz.getDeclaredMethods()) {
                MethodEntry methodEntry;
                if (!method.getName().equals(string) || list.index(methodEntry = new MethodEntry(method)) >= 0) continue;
                list = list.push(methodEntry);
            }
            clazz = clazz.getSuperclass();
        }
        return list;
    }

    public static MethodDB<Method> createMethodDB(Class<?> clazz, String string) {
        return new MethodDB<Method>(MethodDB.getMethods(clazz, string));
    }

    public static MethodDB<Constructor<?>> createConstrDB(Class<?> clazz) {
        List list = List.create(new DBEntry[0]);
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            list = list.push(new ConstrEntry(constructor));
        }
        return new MethodDB(list);
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    public static boolean isDebug() {
        return debug;
    }

    public DBEntry<M> matchEntryFast(Class<?>[] classArray) {
        return MethodDB.matchEntryFast(classArray, classArray.length, this.methods);
    }

    private static <M> DBEntry<M> matchEntryFast(Class<?>[] classArray, int n2, List<DBEntry<M>> list) {
        if (list.isEmpty()) {
            return null;
        }
        DBEntry<M> dBEntry = list.top();
        if (MethodDB.applicable(classArray, n2, dBEntry)) {
            return MethodDB.matchEntryFast(classArray, n2, list.pop(), dBEntry);
        }
        return MethodDB.matchEntryFast(classArray, n2, list.pop());
    }

    private static <M> boolean applicable(Class<?>[] classArray, int n2, DBEntry<M> dBEntry) {
        if (dBEntry.numArgs() > n2) {
            return false;
        }
        for (int j = 0; j < dBEntry.numArgs(); ++j) {
            if (dBEntry.arg(j).isAssignableFrom(classArray[j])) continue;
            return false;
        }
        return true;
    }

    private static <M> DBEntry<M> matchEntryFast(Class<?>[] classArray, int n2, List<DBEntry<M>> list, DBEntry<M> dBEntry) {
        if (list.isEmpty()) {
            return dBEntry;
        }
        DBEntry<M> dBEntry2 = list.top();
        if (MethodDB.applicable(classArray, n2, dBEntry2) && TypeSort.compare(dBEntry2, dBEntry)) {
            return MethodDB.matchEntryFast(classArray, n2, list.pop(), dBEntry2);
        }
        return MethodDB.matchEntryFast(classArray, n2, list.pop(), dBEntry);
    }

    public List<DBEntry<M>> matchAllEntries(final Class<?>[] classArray) {
        return this.methods.filter(new List.Pred<DBEntry<M>>(){

            @Override
            public boolean huh(DBEntry<M> dBEntry) {
                return MethodDB.applicable(classArray, classArray.length, dBEntry);
            }
        });
    }

    public String toString() {
        return this.methods.toString();
    }

    public String toString(String string) {
        return this.methods.toString(string, "");
    }

    public List<DBEntry<M>> prefixApp(final Class<?> clazz) {
        return this.methods.filter(new List.Pred<DBEntry<M>>(){

            @Override
            public boolean huh(DBEntry<M> dBEntry) {
                return dBEntry.numArgs() >= 1 && dBEntry.arg(0).isAssignableFrom(clazz);
            }
        });
    }

    public List<DBEntry<M>> allMethods() {
        return this.methods;
    }
}

