/*
 * Decompiled with CFR 0.152.
 */
package tournament;

import admin.Output;
import admin.TournAdmin;
import admin.utils.AdminDocumentHandler;
import admin.utils.Game;
import edu.neu.ccs.demeterf.Bc;
import edu.neu.ccs.demeterf.TUCombiner;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.stackless.HeapTrav;
import gen.Pair;
import gen.Player;
import gen.PlayerID;
import gen.Store;
import tournament.Match;
import tournament.Pending;
import tournament.Result;
import tournament.Standing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tournament {
    private List<Standing> results;
    private List<Player> players;
    private List<Match> matches;
    Output o;
    Game.GameType gt;

    public Tournament(List<Player> list, String string, Game.GameType gameType) {
        this.players = list;
        this.generateMatches();
        this.o = Output.htmlOutput(string);
        this.gt = gameType;
    }

    private void generateMatches() {
        Pending pending = new Pending();
        this.matches = List.create(new Match[0]);
        for (Player player : this.players) {
            for (Player player2 : this.players) {
                if (player.equals((Object)player2)) continue;
                this.matches = this.matches.append(new Match(player, player2, pending));
            }
        }
    }

    public void runTournament() {
        this.o.header();
        this.matches = (List)new HeapTrav(new TournamentTrav(this.gt, this.matches.length())).traverse(this.matches);
        this.results = TUCombiner.traverse(this.matches, new GatherResults());
        this.results = this.results.sort(new ResultsByWinsAndDraws());
        this.o.footer();
    }

    public List<Standing> getResults() {
        return this.results;
    }

    public List<Match> getMatches() {
        return this.matches;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultsByWinsAndDraws
    extends List.Comp<Standing> {
        private ResultsByWinsAndDraws() {
        }

        @Override
        public boolean comp(Standing standing, Standing standing2) {
            return standing.wins > standing2.wins || standing.wins == standing2.wins && standing.draws > standing2.draws;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GatherResults
    extends TUCombiner<List<Standing>> {
        List<Standing> empty = List.create(new Standing[0]);
        Player fakePlayer = new Player(new PlayerID(0), "Bob");
        private Standing win = new Standing(this.fakePlayer, 1, 0, 0);
        private Standing loss = new Standing(this.fakePlayer, 0, 1, 0);
        private Standing draw = new Standing(this.fakePlayer, 0, 0, 1);

        private GatherResults() {
        }

        @Override
        public List<Standing> combine() {
            return this.empty;
        }

        public List<Standing> combine(Match match) {
            List<Standing> list = this.empty;
            if (match.r.isWhite()) {
                list = list.push(this.win.setPlayer(match.white));
                list = list.push(this.loss.setPlayer(match.black));
            } else if (match.r.isBlack()) {
                list = list.push(this.loss.setPlayer(match.white));
                list = list.push(this.win.setPlayer(match.black));
            } else {
                list = list.push(this.draw.setPlayer(match.white));
                list = list.push(this.draw.setPlayer(match.black));
            }
            return list;
        }

        @Override
        public List<Standing> fold(List<Standing> list, List<Standing> list2) {
            StandingByPlayer standingByPlayer;
            List<Standing> list3 = List.create(new Standing[0]);
            for (Standing standing : list) {
                standingByPlayer = new StandingByPlayer(standing);
                list3 = list3.push(list2.contains(standingByPlayer) ? standing.sum(list2.find(standingByPlayer)) : standing);
            }
            for (Standing standing : list2) {
                standingByPlayer = new StandingByPlayer(standing);
                if (list3.contains(standingByPlayer)) continue;
                list3 = list3.push(standing);
            }
            return list3;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class StandingByPlayer
        extends List.Pred<Standing> {
            Standing s;

            public StandingByPlayer(Standing standing) {
                this.s = standing;
            }

            @Override
            public boolean huh(Standing standing) {
                return this.s.player.equals((Object)standing.player);
            }
        }
    }

    private class TournamentTrav
    extends Bc {
        int gamesPlayed;
        int numGames;
        private TournAdmin ta;
        private Store emptyStore;
        private Game.GameType gt;

        public TournamentTrav(Game.GameType gameType, int n) {
            this.ta = new TournAdmin(Tournament.this.o);
            this.emptyStore = new Store(List.create(new Pair[0]));
            this.gt = gameType;
            this.numGames = n;
            this.gamesPlayed = 0;
        }

        public Match combine(Match match, Player player, Player player2) {
            AdminDocumentHandler.commitStore(this.emptyStore);
            AdminDocumentHandler.deletePlayerTrans(player);
            AdminDocumentHandler.deletePlayerTrans(player2);
            Result result = this.ta.runMatch(player, player2, this.gt);
            Tournament.this.o.playerStart();
            Tournament.this.o.println("White: " + player.print());
            Tournament.this.o.println("Black: " + player2.print());
            Tournament.this.o.println("Result: " + result.print());
            Tournament.this.o.playerEnd();
            System.err.println("Games played: " + ++this.gamesPlayed + " of " + this.numGames);
            return new Match(player, player2, result);
        }
    }
}

