/*
 * Decompiled with CFR 0.152.
 */
package admin;

import admin.Output;
import admin.ProcessWatcher;
import admin.StreamWatcher;
import admin.Util;
import admin.utils.AccountUpdater;
import admin.utils.AdminCmdLineParser;
import admin.utils.AdminDocumentHandler;
import admin.utils.Game;
import admin.utils.RuleChecker;
import admin.utils.StoreUpdater;
import config.AdminConfig;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import gen.Accounts;
import gen.Config;
import gen.Deliver;
import gen.Derivative;
import gen.Finish;
import gen.Pair;
import gen.Player;
import gen.PlayerID;
import gen.PlayerStore;
import gen.PlayerTransaction;
import gen.Players;
import gen.Round;
import gen.Store;
import gen.Transaction;
import java.io.File;
import java.io.IOException;

public class Administrator {
    private Players players = AdminDocumentHandler.getPlayers();
    private Config config = AdminDocumentHandler.getConfig();
    private File playerDir = new File("blackboard" + AdminConfig.PLAYERS_PATH);
    private Store store = AdminDocumentHandler.getStore();
    private Accounts accounts = AdminDocumentHandler.getAccounts();
    Output out;
    Output results;
    String maxStack;
    int roundNum;
    long curTurnFin = System.currentTimeMillis();
    static Runtime runtime = Runtime.getRuntime();

    Administrator(Output output, String string) {
        this(output, output, string);
    }

    Administrator(Output output, Output output2, String string) {
        this.out = output;
        this.results = output2;
        this.roundNum = 1;
        this.maxStack = string;
    }

    public static void main(String[] stringArray) {
        AdminCmdLineParser adminCmdLineParser = new AdminCmdLineParser(stringArray);
        Output output = !adminCmdLineParser.outputFile.equals("") ? Output.htmlOutput(adminCmdLineParser.outputFile) : Output.htmlOutput();
        AdminDocumentHandler.resetFilesToDefault();
        if (!adminCmdLineParser.resultsFile.equals("")) {
            new Administrator(output, Output.htmlOutput(adminCmdLineParser.resultsFile), adminCmdLineParser.maxStack).main(adminCmdLineParser.gt);
        } else {
            new Administrator(output, adminCmdLineParser.maxStack).main(adminCmdLineParser.gt);
        }
    }

    private void main(final Game.GameType gameType) {
        long l = this.curTurnFin;
        this.out.header();
        if (this.results != this.out) {
            this.results.header();
        }
        while (this.roundNum <= this.config.Rounds + 2 && this.players.length() > 1) {
            if (this.overtime(this.roundNum)) {
                this.out.newOTRound(this.roundNum, this.config.Rounds);
                System.err.println(" * Starting Overtime Round #" + (this.roundNum - this.config.Rounds) + " of 2.");
            } else {
                this.out.newRound(this.roundNum, this.config.Rounds);
                System.err.println(" * Starting Round #" + this.roundNum + " of " + this.config.Rounds);
            }
            Round round = new Round(this.roundNum, this.players.players.map(new List.Map<Player, PlayerTransaction>(){

                @Override
                public PlayerTransaction map(Player player) {
                    Administrator.this.out.time("Admin overhead", Administrator.this.curTurnFin);
                    Administrator.this.out.line("");
                    if (Administrator.this.passTurn(player, Administrator.this.roundNum)) {
                        Administrator.this.curTurnFin = System.currentTimeMillis();
                        PlayerTransaction playerTransaction = AdminDocumentHandler.getPlayerTrans(player);
                        if (playerTransaction != null) {
                            Pair<Boolean, String> pair;
                            playerTransaction = Util.checkDerivatives(playerTransaction, Administrator.this.store);
                            playerTransaction = Util.computeQualities(playerTransaction);
                            playerTransaction = Util.truncateRMs(playerTransaction, ((Administrator)Administrator.this).config.MaxRawMaterialLen);
                            if (Administrator.this.overtime(Administrator.this.roundNum)) {
                                List<Transaction> list = playerTransaction.transactions.filter(new List.Pred<Transaction>(){

                                    @Override
                                    public boolean huh(Transaction transaction) {
                                        return transaction.ttype instanceof Deliver || transaction.ttype instanceof Finish;
                                    }
                                });
                                playerTransaction = new PlayerTransaction(playerTransaction.player, list);
                                pair = RuleChecker.overtimeRulesFollowed(playerTransaction, Administrator.this.store, Administrator.this.accounts, gameType, Administrator.this.config);
                            } else {
                                pair = RuleChecker.rulesFollowed(playerTransaction, Administrator.this.store, Administrator.this.accounts, gameType, Administrator.this.config);
                            }
                            if (((Boolean)pair.a).booleanValue()) {
                                Administrator.this.updateStore(playerTransaction);
                                Administrator.this.updateAccounts(playerTransaction);
                                return playerTransaction;
                            }
                            Administrator.this.out.violation((String)pair.b, player);
                        } else {
                            Administrator.this.out.violation("No Transaction", player);
                        }
                    } else {
                        Administrator.this.out.violation("Time Violation or missing jar", player);
                    }
                    Administrator.this.takeViolationAction(Administrator.this.players, player);
                    Administrator.this.players = Administrator.this.players.remove(player.id);
                    return new PlayerTransaction(player, List.create(new Transaction[0]));
                }
            }));
            AdminDocumentHandler.updateHistory(round);
            ++this.roundNum;
        }
        System.err.println("Game finished, calculating results.");
        this.out.time("Admin overhead", this.curTurnFin);
        this.out.time("Total Game time", l);
        this.declareWinner();
        this.out.footer();
    }

    protected boolean overtime(int n) {
        return n > this.config.Rounds;
    }

    private void declareWinner() {
        this.results.finishTable(this.accounts, this.players, AdminDocumentHandler.getPlayers());
        if (this.results != this.out) {
            this.results.footer();
        }
    }

    private void takeViolationAction(Players players, Player player) {
        if (this.store.contains(player.id)) {
            for (Derivative derivative : this.store.getStore((Player)player).bought) {
                this.accounts = this.accounts.update(Util.pair(derivative.seller, -derivative.price.val));
                this.store = this.store.replace(Util.spair(derivative.seller, this.store.getStore(derivative.seller).pushSale(new Derivative(derivative.name, derivative.seller, derivative.price, derivative.type))));
            }
            for (Derivative derivative : players.players) {
                Pair pair = this.store.getStorePair(derivative.id);
                List<Derivative> list = ((PlayerStore)pair.b).bought;
                for (Derivative derivative2 : list) {
                    if (!derivative2.seller.equals((Object)player.id)) continue;
                    this.accounts = this.accounts.update(Util.pair((PlayerID)pair.a, derivative2.price.val));
                    list = list.remove(derivative2);
                }
                ((PlayerStore)pair.b).bought = list;
                this.store = this.store.replace(pair);
            }
        }
        AdminDocumentHandler.commitStore(this.store.remove(player.id));
        AdminDocumentHandler.commitAccounts(this.accounts.remove(player.id));
    }

    private void updateStore(PlayerTransaction playerTransaction) {
        this.store = StoreUpdater.updateStore(this.store, playerTransaction);
        AdminDocumentHandler.commitStore(this.store);
    }

    private void updateAccounts(PlayerTransaction playerTransaction) {
        this.accounts = AccountUpdater.updateAccounts(this.accounts, playerTransaction);
        AdminDocumentHandler.commitAccounts(this.accounts);
    }

    private boolean passTurn(Player player, int n) {
        this.out.println("");
        this.out.line("** Player " + player.id.id + ": Team " + player.name + "'s turn");
        String string = "blackboard" + AdminConfig.PLAYERS_PATH + "/" + player.name;
        String string2 = "java -Xss" + this.maxStack + " -jar " + player.name + ".jar " + player.id.id + " " + n;
        String string3 = string + ".exe " + player.id.id + " " + player.name;
        String string4 = string2;
        if (!new File(string + ".jar").exists()) {
            if (!new File(string + ".exe").exists()) {
                return false;
            }
            string4 = string3;
        }
        long l = 0L;
        long l2 = 0L;
        try {
            l = System.currentTimeMillis();
            this.out.playerStart();
            Process process = runtime.exec(string4, null, this.playerDir);
            StreamWatcher streamWatcher = new StreamWatcher(process.getInputStream(), this.out);
            StreamWatcher streamWatcher2 = new StreamWatcher(process.getErrorStream(), this.out);
            ProcessWatcher processWatcher = new ProcessWatcher(process);
            processWatcher.waitForTimeLimit(this.config.Time);
            l2 = System.currentTimeMillis();
            Thread.sleep(2000L);
            System.out.flush();
            System.err.flush();
            streamWatcher.kill();
            streamWatcher2.kill();
            this.out.playerEnd();
            this.out.time("Player " + player.id.id + ": Team " + player.name + " finished", l);
            this.out.println(this.out.vspace() + this.out.vspace());
            if (l2 - l > (long)this.config.Time) {
                process.destroy();
                return false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return true;
    }
}

