package edu.neu.ccs.satsolver;

// This code was written by Ahmed with some minor changes by me
// to make it easier to use.

public class Relation {	
  public static int reduce(int relnum, int varnum,int value){
    int r,m; // new relation number
    m = getMagicNumber(varnum, value);
    r = (relnum & m);
    if (value==0){
      r = r|(r<<(1<<varnum));
    }else{
      r = r|(r>>(1<<varnum));
    }
    return r; 
  }
  
  static boolean isVariableNotInRelation(int relnum, int varnum){
    int r0 = reduce(relnum, varnum, 0);
    int r1 = reduce(relnum, varnum, 1);
    return (r0==r1);
  }
  
  public static int rank(int relationNumber){
    int rank =3;
    for (int i=0;i<3;i++){
      if (isVariableNotInRelation(relationNumber, i)) rank--;
    }
    return rank;
  }
  
  public static int q(int relationNumber,int sub/*0,1,2,3*/){
    int m;
    switch (sub){
    case 0:
      m=1;
      break;
    case 1:
      m=22;
      break;
    case 2:
      m=104;
      break;
    case 3:
      m=128;
      break;
    default:
      m=0;
      System.out.println("Sub can be 0,1,2,or 3");
    }
    return ones((relationNumber&m));
  }
  
  public static int ones(int relationNumber){
    int c=0;
    for(int i=0;i<8;i++){
      if ((relationNumber&(1<<i))!=0) c++;
    }
    return c;
  }
  
  public static int getMagicNumber(int variableNumber,int value){
    //ToDo: use xor, see if there is a default return value 
    if(value==0){
      if(variableNumber==0) return 85; /*1st var (Least Significant), value 0*/
      if(variableNumber==1) return 51;
      if(variableNumber==2) return 15; /*last var (Most Significant), value 0*/
      System.out.println("Only 3 variable Numbers are allowed 0,1,2");
    }else if(value ==1){
      if(variableNumber==0) return 170; /*1st var (Least Significant), value 1*/
      if(variableNumber==1) return 204;
      if(variableNumber==2) return 240; /*last var (Most Significant), value 0*/
      System.out.println("Only 3 variable Numbers are allowed 0,1,2");
    }else{
      System.out.println("Only 0 or 1 are allowed as values");
    }
    return -1;
  }

  /**
   * Returns the R for this constraint.
   */
  public static int converttor(int[] constraint) {
    int r = 0;

    for(int i=0; i < constraint.length; i++) {
      int magic;
      if (constraint[i] == 1) {
        magic = Relation.getMagicNumber(2 - i, 1);
      } else {
        magic = Relation.getMagicNumber(2 - i, 0);
      }
      r = r | magic;
    }

    return r;
  }

  public static void main(String args[]) {
    int r = Integer.parseInt(args[0]);
    System.out.println("r: " + r);
    if (r < 0 || r > 255) {
      System.out.println("Invalid r!");
    } else {

      System.out.println("rank: " + rank(r) + " (3)");
      for(int s=0; s <= 3; s++) {
        System.out.println("q" + s + ":   " + q(r, s));
      }
    }
    System.out.println("254: " + reduce(254, 2, 0));
  }
}
