/*
 * Decompiled with CFR 0.152.
 */
package admin.utils;

import edu.neu.ccs.demeterf.Control;
import edu.neu.ccs.demeterf.TUCombiner;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import gen.Accounts;
import gen.Buy;
import gen.Derivative;
import gen.Finish;
import gen.FinishedProduct;
import gen.Pair;
import gen.Player;
import gen.PlayerID;
import gen.PlayerTransaction;
import gen.Transaction;
import gen.TransactionType;
import utils.ListTUCombiner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountUpdater {
    public static Accounts updateAccounts(Accounts accounts, PlayerTransaction playerTransaction) {
        List<Pair<PlayerID, Double>> list = AccountUpdater.changes(playerTransaction.transactions, playerTransaction.player);
        return list.fold(new List.Fold<Pair<PlayerID, Double>, Accounts>(){

            @Override
            public Accounts fold(Pair<PlayerID, Double> pair, Accounts accounts) {
                return accounts.update(pair);
            }
        }, accounts);
    }

    static List<Pair<PlayerID, Double>> changes(List<Transaction> list, Player player) {
        return TUCombiner.traverse(list, new AccountChanges(player), Control.builtins(TransactionType.class, Derivative.class));
    }

    static Pair<PlayerID, Double> pair(PlayerID playerID, Double d) {
        return new Pair((Object)playerID, (Object)d);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AccountChanges
    extends ListTUCombiner<Pair<PlayerID, Double>> {
        Player player;

        AccountChanges(Player player) {
            this.player = player;
        }

        TransactionType combine(TransactionType transactionType) {
            return transactionType;
        }

        List<Pair<PlayerID, Double>> combine(Transaction transaction, TransactionType transactionType) {
            return this.combine();
        }

        List<Pair<PlayerID, Double>> combine(Transaction transaction, Buy buy) {
            return List.create(AccountUpdater.pair(this.player.id, -transaction.deriv.price.val), AccountUpdater.pair(transaction.deriv.seller, transaction.deriv.price.val));
        }

        List<Pair<PlayerID, Double>> combine(Transaction transaction, Finish finish) {
            return List.create(AccountUpdater.pair(this.player.id, ((FinishedProduct)transaction.deriv.optfinished.inner()).quality.val), AccountUpdater.pair(transaction.deriv.seller, -((FinishedProduct)transaction.deriv.optfinished.inner()).quality.val));
        }
    }
}

