/*
 * Decompiled with CFR 0.152.
 */
package admin;

import edu.neu.ccs.demeterf.demfgen.lib.List;
import gen.Accounts;
import gen.Pair;
import gen.Player;
import gen.PlayerID;
import gen.Players;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Date;

public abstract class Output {
    static DecimalFormat form = new DecimalFormat("0.0000");
    public static String[] superS = new String[]{"st", "nd", "rd", "th"};
    PrintStream out;

    public static void main(String[] stringArray) {
        List<Pair<PlayerID, Double>> list = List.buildlist(new List.Build<Pair<PlayerID, Double>>(){

            @Override
            public Pair<PlayerID, Double> build(int n) {
                return new Pair((Object)new PlayerID(n), (Object)(Math.random() * 5.0 - 2.0));
            }
        }, 10);
        List<Player> list2 = list.map(new List.Map<Pair<PlayerID, Double>, Player>(){

            @Override
            public Player map(Pair<PlayerID, Double> pair) {
                return new Player((PlayerID)pair.a, "PLAYER#" + ((PlayerID)pair.a).print());
            }
        });
        Output output = Output.htmlOutput();
        output.header();
        output.finishTable(new Accounts(list), new Players(list2.pop(4)), new Players(list2));
        output.footer();
    }

    public static String suffix(int n) {
        return superS[Math.min(3, n - 1)];
    }

    protected Output(PrintStream printStream) {
        this.out = printStream;
    }

    public String vspace() {
        return "\n";
    }

    public void println(String string) {
        this.print(string + "\n");
    }

    public abstract void playerStart();

    public abstract void playerEnd();

    public abstract void line(String var1);

    public abstract void line(String var1, String var2);

    public abstract void print(String var1);

    public abstract void header();

    public abstract void footer();

    public abstract void finishTable(Accounts var1, Players var2, Players var3);

    public void newRound(int n, int n2) {
        this.line(this.vspace() + "***** ROUND " + n + " of " + n2 + " *****" + this.vspace(), "blue");
    }

    public void newOTRound(int n, int n2) {
        this.line(this.vspace() + "***** OVERTIME ROUND " + (n - n2) + " of 2 *****" + this.vspace(), "blue");
    }

    public void time(String string, long l) {
        this.line("** " + string + ": " + form.format((double)(System.currentTimeMillis() - l) / 1000.0));
    }

    public void violation(String string, Player player) {
        this.line(this.vspace() + this.vspace() + "***** Player " + player.id.id + " (" + player.name + ") has violated a rule! *****" + this.vspace(), "red");
        for (String string2 : string.split("\n")) {
            this.line("***** " + string2, "red");
        }
        this.line("");
    }

    protected static Output die(String string) {
        System.err.println(" ** ERROR OPENING OUTPUT FILE: " + string);
        System.exit(1);
        return null;
    }

    public static Output termOutput() {
        return new TERM();
    }

    public static Output termOutput(String string) {
        try {
            return new TERM(new PrintStream(new FileOutputStream(string)));
        }
        catch (IOException iOException) {
            return Output.die(string);
        }
    }

    public static Output htmlOutput() {
        return new HTML();
    }

    public static Output htmlOutput(String string) {
        try {
            return new HTML(new PrintStream(new FileOutputStream(string)));
        }
        catch (IOException iOException) {
            return Output.die(string);
        }
    }

    public static class HTML
    extends TERM {
        protected HTML() {
            this(System.err);
        }

        protected HTML(PrintStream printStream) {
            super(printStream);
        }

        public String vspace() {
            return "<br/>";
        }

        public void line(String string) {
            this.println(string + "<br/>");
        }

        public void line(String string, String string2) {
            this.line("<span style='color:" + string2 + ";'>" + string + "</span>");
        }

        public String head() {
            return "<html><head><title> Competition: " + new Date() + "</title></head>\n<body>";
        }

        public void footer() {
            this.println("\n</body></html>\n");
        }

        protected static String wrap(String string, String string2) {
            return HTML.wrap(string, string2, "", false);
        }

        protected static String border(String string, String string2) {
            return HTML.wrap(string, string2, " style='border: 1px solid blue; padding:3px;'", false);
        }

        private static String wrap(String string, String string2, String string3, boolean bl) {
            return "<" + string2 + string3 + ">" + (bl ? "\n" : "") + string + (bl ? "\n" : "") + "</" + string2 + ">";
        }

        public void playerStart() {
            this.println("<blockquote style='border:dotted 1px blue'><pre>");
            this.indent = this.indent + "   ";
        }

        public void playerEnd() {
            this.indent = this.indent.substring(3);
            this.println("</pre></blockquote>");
        }

        public void finishTable(Accounts accounts, final Players players, final Players players2) {
            this.println("\n<hr align='left' width='400px'><blockquote>\n" + HTML.wrap("***** Final Results! *****", "h3"));
            String string = accounts.accounts.sort(new List.Comp<Pair<PlayerID, Double>>(){

                @Override
                public boolean comp(Pair<PlayerID, Double> pair, Pair<PlayerID, Double> pair2) {
                    return !players.contains((PlayerID)pair2.a) || players.contains((PlayerID)pair.a) && (Double)pair.b > (Double)pair2.b;
                }
            }).foldl(new List.Fold<Pair<PlayerID, Double>, String>(){
                int place = 0;
                int n = 0;

                @Override
                public String fold(Pair<PlayerID, Double> pair, String string) {
                    ++this.n;
                    String string2 = players2.forID((PlayerID)((PlayerID)pair.a)).name;
                    double d = (Double)pair.b;
                    String string3 = players.contains((PlayerID)pair.a) ? (d >= 0.0 ? ++this.place + HTML.wrap(superS[Math.min(3, this.place - 1)], "sup") : "Neg") : "----";
                    String string4 = string3;
                    return string + "    " + HTML.wrap(HTML.border(string4, "td") + HTML.border("Player# " + ((PlayerID)pair.a).print(), "td") + HTML.border(string2, "td") + HTML.border("$ " + form.format(d), "td"), "tr", this.n % 2 == 1 ? " style='background:lightgray'" : "", false) + "\n";
                }
            }, "\n");
            this.println(HTML.border(string, "table") + "\n</blockquote>\n");
        }
    }

    static class TERM
    extends Output {
        String indent;

        protected TERM() {
            this(System.err);
        }

        protected TERM(PrintStream printStream) {
            super(printStream);
        }

        public void line(String string) {
            this.println(" " + string);
        }

        public void line(String string, String string2) {
            this.line(string);
        }

        public void print(String string) {
            this.out.print(string);
        }

        String head() {
            return "";
        }

        public void footer() {
        }

        public void header() {
            this.println(this.head());
            this.line("***** Competition Csu670 SDG Game *****", "blue");
            this.line("***** Date: " + new Date() + " *****", "blue");
            this.line("");
        }

        public void playerStart() {
            this.indent = this.indent + "     ";
        }

        public void playerEnd() {
            this.indent = this.indent.substring(5);
        }

        public void finishTable(Accounts accounts, final Players players, final Players players2) {
            this.println("\n ***** Final Results! *****");
            final int n = players2.players.fold(new List.Fold<Player, Integer>(){

                @Override
                public Integer fold(Player player, Integer n) {
                    return Math.max(player.name.length(), n);
                }
            }, 0);
            String string = accounts.accounts.sort(new List.Comp<Pair<PlayerID, Double>>(){

                @Override
                public boolean comp(Pair<PlayerID, Double> pair, Pair<PlayerID, Double> pair2) {
                    return !players.contains((PlayerID)pair2.a) || players.contains((PlayerID)pair.a) && (Double)pair.b > (Double)pair2.b;
                }
            }).foldl(new List.Fold<Pair<PlayerID, Double>, String>(){
                int place = 0;

                @Override
                public String fold(Pair<PlayerID, Double> pair, String string) {
                    String string2 = players2.forID((PlayerID)((PlayerID)pair.a)).name;
                    double d = (Double)pair.b;
                    String string3 = players.contains((PlayerID)pair.a) ? (d >= 0.0 ? ++this.place + "^" + superS[Math.min(3, this.place - 1)] : "Neg") : "----";
                    String string4 = string3;
                    return string + "    " + string4 + "   Player# " + ((PlayerID)pair.a).print() + "   " + TERM.this.pad(string2, n) + "     $ " + form.format(d) + "\n";
                }
            }, "\n");
            this.println(string);
        }

        public String pad(String string, int n) {
            return n <= string.length() ? string : this.pad(string + " ", n);
        }
    }
}

