/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.evergreen.ir;

import edu.neu.ccs.evergreen.ir.CustomCounter;
import edu.neu.ccs.evergreen.ir.RelationCore;
import edu.neu.ccs.evergreen.ir.RelationNumberUtil;
import org.junit.Assert;
import org.junit.Test;

public class RelationCoreSwapRenameTest {
    int maxRank = 5;

    @Test
    public final void testSwap() {
        int variablePosition1;
        int rank = 1;
        while (rank < this.maxRank) {
            variablePosition1 = 0;
            while (variablePosition1 < rank) {
                int variablePosition2 = 0;
                while (variablePosition2 < rank) {
                    int value = 0;
                    while (value <= 1) {
                        int relationNumber1 = RelationCore.getMagicNumber(rank, variablePosition1, value);
                        int relationNumber2 = RelationCore.getMagicNumber(rank, variablePosition2, value);
                        int swappedRelationNumber1 = RelationCore.swap(relationNumber1, rank, variablePosition1, variablePosition2);
                        Assert.assertTrue((swappedRelationNumber1 == relationNumber2 ? 1 : 0) != 0);
                        ++value;
                    }
                    ++variablePosition2;
                }
                ++variablePosition1;
            }
            ++rank;
        }
        rank = 1;
        while (rank < this.maxRank) {
            int originalRelationNumber;
            int swappedRelationNumber;
            int variablePosition2;
            int variablePosition12;
            int relationNumber;
            if (RelationCore.getMask(rank) > 0) {
                relationNumber = 0;
                while (relationNumber < RelationCore.getMask(rank)) {
                    variablePosition12 = 0;
                    while (variablePosition12 < rank) {
                        variablePosition2 = 0;
                        while (variablePosition2 < rank) {
                            swappedRelationNumber = RelationCore.swap(relationNumber, rank, variablePosition12, variablePosition2);
                            originalRelationNumber = RelationCore.swap(swappedRelationNumber, rank, variablePosition12, variablePosition2);
                            Assert.assertTrue((relationNumber == originalRelationNumber ? 1 : 0) != 0);
                            ++variablePosition2;
                        }
                        ++variablePosition12;
                    }
                    ++relationNumber;
                }
            } else {
                relationNumber = -1;
                while (relationNumber < 0x7FFFFFFE) {
                    variablePosition12 = 0;
                    while (variablePosition12 < rank) {
                        variablePosition2 = 0;
                        while (variablePosition2 < rank) {
                            swappedRelationNumber = RelationCore.swap(relationNumber, rank, variablePosition12, variablePosition2);
                            originalRelationNumber = RelationCore.swap(swappedRelationNumber, rank, variablePosition12, variablePosition2);
                            Assert.assertTrue((relationNumber == originalRelationNumber ? 1 : 0) != 0);
                            ++variablePosition2;
                        }
                        ++variablePosition12;
                    }
                    ++relationNumber;
                }
                variablePosition1 = 0;
                while (variablePosition1 < rank) {
                    int relationNumber2 = Integer.MAX_VALUE;
                    variablePosition2 = 0;
                    while (variablePosition2 < rank) {
                        swappedRelationNumber = RelationCore.swap(relationNumber2, rank, variablePosition1, variablePosition2);
                        originalRelationNumber = RelationCore.swap(swappedRelationNumber, rank, variablePosition1, variablePosition2);
                        Assert.assertTrue((relationNumber2 == originalRelationNumber ? 1 : 0) != 0);
                        ++variablePosition2;
                    }
                    ++variablePosition1;
                }
            }
            ++rank;
        }
    }

    @Test
    public final void testRenme() {
        int rank = 1;
        while (rank <= this.maxRank) {
            int[] allVars = new int[rank];
            int var = 0;
            while (var < rank) {
                allVars[var] = var;
                ++var;
            }
            int[] relationNumbers = new int[4 + rank + 1];
            relationNumbers[0] = RelationNumberUtil.and(rank, allVars);
            relationNumbers[1] = RelationNumberUtil.nMap(RelationNumberUtil.and(rank, allVars), rank, allVars);
            relationNumbers[2] = RelationNumberUtil.or(rank, allVars);
            relationNumbers[3] = RelationNumberUtil.nMap(RelationNumberUtil.or(rank, allVars), rank, allVars);
            int i = 0;
            while (i <= rank) {
                relationNumbers[4 + i] = RelationNumberUtil.xTrueVars(rank, i);
                ++i;
            }
            int[] nArray = relationNumbers;
            int n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                int relationNumber = nArray[n];
                CustomCounter p = new CustomCounter(rank, 0, rank - 1);
                while (p.hasNextPermutation()) {
                    int[] permutation = p.nextPermutation();
                    int permutedRelationNumber = RelationCore.renme(relationNumber, rank, 0, permutation);
                    Assert.assertTrue((relationNumber == permutedRelationNumber ? 1 : 0) != 0);
                    permutation = p.getPermutation();
                    int originalRelationNumber = RelationCore.renme(relationNumber, rank, 1, permutation);
                    Assert.assertTrue((relationNumber == originalRelationNumber ? 1 : 0) != 0);
                }
                ++n;
            }
            ++rank;
        }
        rank = 1;
        while (rank < this.maxRank) {
            int originalRelationNumber;
            int relationNumber;
            if (RelationCore.getMask(rank) > 0) {
                relationNumber = 0;
                while (relationNumber < RelationCore.getMask(rank)) {
                    CustomCounter p = new CustomCounter(rank, 0, rank - 1);
                    while (p.hasNextPermutation()) {
                        int[] permutation = p.nextPermutation();
                        int permutedRelationNumber = RelationCore.renme(relationNumber, rank, 0, permutation);
                        originalRelationNumber = RelationCore.renme(permutedRelationNumber, rank, 1, permutation = p.getPermutation());
                        Assert.assertTrue((relationNumber == originalRelationNumber ? 1 : 0) != 0);
                    }
                    ++relationNumber;
                }
            } else {
                relationNumber = -1;
                while (relationNumber < 0x7FFFFFFE) {
                    CustomCounter p = new CustomCounter(rank, 0, rank - 1);
                    while (p.hasNextPermutation()) {
                        int[] permutation = p.nextPermutation();
                        int permutedRelationNumber = RelationCore.renme(relationNumber, rank, 0, permutation);
                        originalRelationNumber = RelationCore.renme(permutedRelationNumber, rank, 0, permutation);
                        Assert.assertTrue((relationNumber == originalRelationNumber ? 1 : 0) != 0);
                    }
                    ++relationNumber;
                }
                int variablePosition1 = 0;
                while (variablePosition1 < rank) {
                    int relationNumber2 = Integer.MAX_VALUE;
                    CustomCounter p = new CustomCounter(rank, 0, rank - 1);
                    while (p.hasNextPermutation()) {
                        int[] permutation = p.nextPermutation();
                        int permutedRelationNumber = RelationCore.renme(relationNumber2, rank, 0, permutation);
                        int originalRelationNumber2 = RelationCore.renme(permutedRelationNumber, rank, 0, permutation);
                        Assert.assertTrue((relationNumber2 == originalRelationNumber2 ? 1 : 0) != 0);
                    }
                    ++variablePosition1;
                }
            }
            ++rank;
        }
    }
}

