/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.evergreen.ir;

import edu.neu.ccs.evergreen.ir.RelationCore;
import org.junit.Assert;
import org.junit.Test;

public class RelationCoreChecksTest {
    int maxRank = 5;

    @Test
    public void testCheckRelationNumberInrange() {
        int rank = 1;
        while (rank <= this.maxRank) {
            int i = 0;
            while (i < RelationCore.getMask(rank)) {
                RelationCore.checkRelationNumber(i, rank);
                ++i;
            }
            ++rank;
        }
    }

    @Test
    public void testCheckRelationNumberOutOfRange() {
        int testCount = 0;
        int ExceptionCount = 0;
        int rank = 1;
        while (rank >= this.maxRank) {
            try {
                ++testCount;
                RelationCore.checkRelationNumber(-1, rank);
            }
            catch (IllegalArgumentException e) {
                ++ExceptionCount;
            }
            try {
                ++testCount;
                RelationCore.checkRelationNumber(RelationCore.getMask(rank) + 1, rank);
            }
            catch (IllegalArgumentException e) {
                ++ExceptionCount;
            }
            ++rank;
        }
        Assert.assertTrue((ExceptionCount == testCount ? 1 : 0) != 0);
    }

    @Test
    public void testCheckVariablePositionInRange() {
        int rank = 1;
        while (rank <= this.maxRank) {
            int i = 0;
            while (i < rank) {
                RelationCore.checkVariablePosition(i, rank);
                ++i;
            }
            ++rank;
        }
    }

    @Test
    public void testCheckVariablePositionOutOfRange() {
        int testCount = 0;
        int ExceptionCount = 0;
        int rank = 1;
        while (rank >= this.maxRank) {
            try {
                ++testCount;
                RelationCore.checkVariablePosition(-1, rank);
            }
            catch (IllegalArgumentException e) {
                ++ExceptionCount;
            }
            try {
                ++testCount;
                RelationCore.checkVariablePosition(rank, rank);
            }
            catch (IllegalArgumentException e) {
                ++ExceptionCount;
            }
            ++rank;
        }
        Assert.assertTrue((ExceptionCount == testCount ? 1 : 0) != 0);
    }
}

