/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.examples;

import edu.neu.ccs.demeterf.Control;
import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.Traversal;
import edu.neu.ccs.demeterf.demfgen.lib.Cons;
import edu.neu.ccs.demeterf.demfgen.lib.Empty;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.examples.Char;
import edu.neu.ccs.demeterf.examples.NewLine;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Editor
extends JComponent
implements KeyListener {
    List<Char> buff = List.create(new Char[0]);
    List<Char> clip = this.buff;
    int len = 0;
    int index = 0;
    int select = -1;
    static Font font = new Font("courier", 0, 12);
    String file = "";

    Editor() {
    }

    void checkSelect(KeyEvent keyEvent) {
        if (keyEvent.isShiftDown()) {
            if (this.select < 0) {
                this.select = this.index;
            }
        } else {
            this.select = -1;
        }
    }

    FRes findLine(List<Char> list) {
        int n2 = 0;
        while (!list.isEmpty() && !list.top().isNewLine()) {
            list = list.pop();
            ++n2;
        }
        return new FRes(n2, list);
    }

    void delete(boolean bl) {
        if (!this.buff.isEmpty()) {
            if (this.select < 0) {
                if (bl && this.index > 0 || !bl && this.index != this.len) {
                    if (bl) {
                        --this.index;
                    }
                    this.buff = this.buff.remove(this.index);
                    --this.len;
                }
            } else {
                int n2 = Math.min(this.select, this.index);
                int n3 = Math.max(this.select, this.index);
                for (int j = 0; j < n3 - n2; ++j) {
                    this.buff = this.buff.remove(n2);
                }
                this.select = -1;
                this.index = n2;
                this.len -= n3 - n2;
            }
        }
    }

    boolean testChar(Char char_, boolean bl) {
        return bl == Character.isLetter(char_.toChar());
    }

    int LRarrow(KeyEvent keyEvent, List<Char> list) {
        int n2 = 0;
        if (keyEvent.isControlDown()) {
            if (!list.isEmpty()) {
                int n3;
                boolean bl = Character.isLetter(list.top().toChar());
                int n4 = n3 = bl ? 1 : 2;
                while (true) {
                    if (!list.isEmpty() && this.testChar(list.top(), bl)) {
                        list = list.pop();
                        ++n2;
                        continue;
                    }
                    bl = true;
                    if (--n3 <= 0) break;
                }
            }
        } else {
            n2 = 1;
        }
        return n2;
    }

    int UParrow(KeyEvent keyEvent, List<Char> list) {
        if (keyEvent.isControlDown()) {
            return this.len;
        }
        FRes fRes = this.findLine(list);
        if (fRes.lst.isEmpty()) {
            return fRes.dist;
        }
        return Math.max(this.findLine(fRes.lst.pop()).dist + 1, fRes.dist + 1);
    }

    int DNarrow(KeyEvent keyEvent, List<Char> list) {
        if (keyEvent.isControlDown()) {
            return this.len;
        }
        FRes fRes = this.findLine(list.reverse(this.index));
        FRes fRes2 = this.findLine(list.pop(this.index));
        if (fRes2.lst.isEmpty()) {
            return fRes2.dist;
        }
        return Math.min(fRes2.dist + fRes.dist + 1, fRes2.dist + this.findLine(fRes2.lst.pop()).dist + 1);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 35: {
                this.checkSelect(keyEvent);
                this.index += this.findLine(this.buff.pop((int)this.index)).dist;
                break;
            }
            case 36: {
                this.checkSelect(keyEvent);
                this.index -= this.findLine(this.buff.reverse((int)this.index)).dist;
                break;
            }
            case 37: {
                this.checkSelect(keyEvent);
                this.index -= this.LRarrow(keyEvent, this.buff.reverse(this.index));
                break;
            }
            case 39: {
                this.checkSelect(keyEvent);
                this.index += this.LRarrow(keyEvent, this.buff.pop(this.index));
                break;
            }
            case 38: {
                this.checkSelect(keyEvent);
                this.index -= this.UParrow(keyEvent, this.buff.reverse(this.index));
                break;
            }
            case 40: {
                this.checkSelect(keyEvent);
                this.index += this.DNarrow(keyEvent, this.buff);
            }
        }
        if (this.index < 0) {
            this.index = 0;
        }
        if (this.index > this.len) {
            this.index = this.len;
        }
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.isControlDown()) {
            this.control(keyEvent);
            return;
        }
        switch (keyEvent.getKeyChar()) {
            case '\b': {
                this.delete(true);
                break;
            }
            case '\u007f': {
                this.delete(false);
                break;
            }
            default: {
                this.buff = this.buff.add(Char.create(keyEvent.getKeyChar()), this.index++);
                ++this.len;
            }
        }
        this.repaint();
    }

    void control(KeyEvent keyEvent) {
        System.out.println("CONTROL:" + keyEvent.getKeyChar() + " == " + 65535);
        System.out.println("CODE:" + keyEvent.getKeyCode());
        switch (keyEvent.getKeyChar()) {
            case '\u0013': {
                this.save();
                break;
            }
            case '\u0017': {
                this.write(this.file, true);
                break;
            }
            case '\u0006': {
                this.open();
                break;
            }
            case '\u0003': {
                this.copy();
                break;
            }
            case '\u0016': {
                this.paste();
                break;
            }
            case '\u0018': {
                this.cut();
            }
        }
    }

    @Override
    public void paint(final Graphics graphics) {
        graphics.setFont(font);
        graphics.drawRect(5, 5, this.getWidth() - 10, this.getHeight() - 10);
        new Traversal(new ID(){

            int update(Cons cons, Cons.rest rest2, int n2) {
                return n2 - 1;
            }

            Pos combine(Empty empty, int n2) {
                return this.cursor(graphics, new Pos(12, 24), n2, 0);
            }

            Pos combine(Cons<Char> cons, NewLine newLine, Pos pos, int n2) {
                return this.cursor(graphics, new Pos(12, pos.y + 15), n2, -1);
            }

            Pos combine(Cons<Char> cons, Char char_, Pos pos, int n2) {
                int n3 = graphics.getFontMetrics().charWidth(char_.toChar()) + 1;
                this.cursor(graphics, pos, n2, n3);
                this.selection(graphics, pos, n2, n3);
                graphics.drawChars(new char[]{char_.toChar()}, 0, 1, pos.x, pos.y);
                if (pos.x + n3 > Editor.this.getWidth() - 24) {
                    return new Pos(12, pos.y + 15);
                }
                return new Pos(pos.x + n3, pos.y);
            }

            Pos cursor(Graphics graphics2, Pos pos, int n2, int n3) {
                if (n2 == Editor.this.index) {
                    graphics2.fillRect(pos.x + n3, pos.y - 12, 2, 15);
                }
                return pos;
            }

            void selection(Graphics graphics2, Pos pos, int n2, int n3) {
                if (Editor.this.select < 0) {
                    return;
                }
                if (Editor.this.index > Editor.this.select && Editor.this.select < n2 && n2 <= Editor.this.index || Editor.this.index < Editor.this.select && Editor.this.index < n2 && n2 <= Editor.this.select) {
                    Color color2 = graphics2.getColor();
                    graphics2.setColor(Color.lightGray);
                    graphics2.fillRect(pos.x, pos.y - 12, n3, 15);
                    graphics2.setColor(color2);
                }
            }
        }, (Control)Control.builtins(Char.class)).traverse(this.buff.reverse(), this.len);
    }

    void save() {
        if (this.file.length() == 0) {
            this.write("untitled.txt", true);
        } else {
            this.write(this.file, false);
        }
    }

    void write(String string, boolean bl) {
        List list;
        if (bl) {
            int n2;
            if (string.charAt(0) != '/') {
                string = "./" + string;
            }
            if ((n2 = ((JFileChooser)((Object)(list = new JFileChooser(string.substring(0, string.lastIndexOf(47)))))).showSaveDialog(this)) == 0) {
                this.file = string = ((JFileChooser)((Object)list)).getSelectedFile().getAbsolutePath();
            } else {
                return;
            }
        }
        list = this.buff;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            while (!list.isEmpty()) {
                fileOutputStream.write(list.top().toChar());
                list = list.pop();
            }
        }
        catch (IOException iOException) {
            System.err.println("ERROR: " + iOException);
        }
    }

    void open() {
        JFileChooser jFileChooser;
        int n2;
        String string = this.file;
        if (this.file.length() == 0 || string.charAt(0) != '/') {
            string = "./" + string;
        }
        if ((n2 = (jFileChooser = new JFileChooser(string.substring(0, string.lastIndexOf(47)))).showOpenDialog(this)) != 0) {
            return;
        }
        string = jFileChooser.getSelectedFile().getAbsolutePath();
        System.err.println("FILE: " + string);
        this.file = string;
        this.buff = Editor.read(string);
        this.index = 0;
        this.len = this.buff.length();
        this.repaint();
    }

    void copy() {
        int n2 = Math.min(this.select, this.index);
        int n3 = Math.max(this.select, this.index);
        this.clip = this.buff.reverse(n3).reverse(n3 - n2);
        this.select = -1;
    }

    void cut() {
        int n2 = this.select;
        if (n2 >= 0) {
            this.copy();
            this.select = n2;
            this.delete(true);
        }
    }

    void paste() {
        System.out.println("Paste: " + this.clip);
        if (!this.clip.isEmpty()) {
            if (this.select >= 0) {
                this.delete(true);
            }
            List<Char> list = this.clip.reverse();
            while (!list.isEmpty()) {
                this.buff = this.buff.add(list.top(), this.index);
                ++this.len;
                list = list.pop();
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        Editor editor = new Editor();
        jFrame.getContentPane().add(editor);
        jFrame.addKeyListener(editor);
        jFrame.setSize(300, 300);
        jFrame.setLocation(200, 100);
        jFrame.setVisible(true);
    }

    public static List<Char> read(String string) {
        List<Char> list = List.create(new Char[0]);
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            while (fileInputStream.available() > 0) {
                list = list.push(Char.create((char)fileInputStream.read()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list.reverse();
    }

    public static class Pos {
        int x;
        int y;

        Pos(int n2, int n3) {
            this.x = n2;
            this.y = n3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FRes {
        int dist;
        List<Char> lst;

        FRes(int n2, List<Char> list) {
            this.dist = n2;
            this.lst = list;
        }
    }
}

