/*
 * Decompiled with CFR 0.152.
 */
package admin.utils;

import admin.utils.AdminDocumentHandler;
import admin.utils.Game;
import admin.utils.SufficientAssignment;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import gen.Accounts;
import gen.Assignment;
import gen.Buy;
import gen.Config;
import gen.Constraint;
import gen.Create;
import gen.Deliver;
import gen.Derivative;
import gen.Finish;
import gen.FinishedProduct;
import gen.Pair;
import gen.PlayerID;
import gen.PlayerTransaction;
import gen.Price;
import gen.RawMaterial;
import gen.Reoffer;
import gen.Store;
import gen.Transaction;
import gen.TransactionType;
import gen.Type;
import gen.TypeInstance;
import gen.Variable;
import utils.DerivativesFinder;
import utils.comparator.CheaperDerivative;
import utils.comparator.DerivativeComp;
import utils.comparator.SameDerivative;
import utils.comparator.SameDerivativeByType;
import utils.comparator.TransactionComparatorByTType;
import utils.comparator.TypeInstanceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleChecker {
    String message = "";
    PlayerTransaction pTrans;
    Config config;

    protected RuleChecker(PlayerTransaction playerTransaction, Config config) {
        this.pTrans = playerTransaction;
        this.config = config;
    }

    void addMessage(String string) {
        this.message = this.message + string + "\n";
    }

    public static Pair<Boolean, String> rulesFollowed(PlayerTransaction playerTransaction, Store store, Accounts accounts, Game.GameType gameType, Config config) {
        return new RuleChecker(playerTransaction, config).rulesFollowed(store, accounts, gameType);
    }

    public static Pair<Boolean, String> overtimeRulesFollowed(PlayerTransaction playerTransaction, Store store, Accounts accounts, Game.GameType gameType, Config config) {
        return new RuleChecker(playerTransaction, config).overtimeRulesFollowed(store, accounts);
    }

    public Pair<Boolean, String> rulesFollowed(Store store, Accounts accounts, Game.GameType gameType) {
        boolean bl = this.isAccountPositive(accounts);
        boolean bl2 = this.isBuyOrReofferRuleFollowed(store);
        boolean bl3 = this.isCreateRuleFollowed(store, gameType);
        boolean bl4 = this.isDeliveryRuleFollowed(store);
        boolean bl5 = this.isFinishRuleFollowed(store);
        return new Pair((Object)(bl && bl2 && bl3 && bl4 && bl5 ? 1 : 0), (Object)this.message);
    }

    public Pair<Boolean, String> overtimeRulesFollowed(Store store, Accounts accounts) {
        boolean bl = this.isAccountPositive(accounts);
        boolean bl2 = this.isDeliveryRuleFollowed(store);
        boolean bl3 = this.isFinishRuleFollowed(store);
        return new Pair((Object)(bl && bl2 && bl3 ? 1 : 0), (Object)this.message);
    }

    protected boolean isAccountPositive(Accounts accounts) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (Pair pair : accounts.accounts) {
            if (!((PlayerID)pair.a).equals((Object)this.pTrans.player.id)) continue;
            d = (Double)pair.b;
        }
        for (Pair pair : this.pTrans.transactions) {
            if (pair.ttype.getClass().equals(Buy.class)) {
                d2 += pair.deriv.price.val;
            }
            if (!pair.ttype.getClass().equals(Finish.class)) continue;
            d3 += ((FinishedProduct)pair.deriv.optfinished.inner()).quality.val;
        }
        if (d + d3 - d2 < 0.0) {
            this.addMessage("Negative account balance");
            return false;
        }
        return true;
    }

    protected boolean isBuyOrReofferRuleFollowed(Store store) {
        if (this.emptyStoreBuyReoffer(store) && !store.stores.isEmpty() && !DerivativesFinder.findDerivativesForSaleByOthers(store.stores, this.pTrans.player.id).isEmpty()) {
            if (!this.pTrans.transactions.contains(new TransactionComparatorByTType((TransactionType)new Buy())) && !this.pTrans.transactions.contains(new TransactionComparatorByTType((TransactionType)new Reoffer()))) {
                this.addMessage("No Buy/Reoffer from a non-empty store");
                return false;
            }
            if (this.pTrans.transactions.contains(new TransactionComparatorByTType((TransactionType)new Buy()))) {
                return this.correctBuy(store);
            }
            Config config = AdminDocumentHandler.getConfig();
            return this.correctReoffer(store, config.MPD);
        }
        return true;
    }

    protected boolean correctReoffer(Store store, final double d) {
        List<Transaction> list = this.pTrans.transactions.filter(new TransactionComparatorByTType((TransactionType)new Reoffer()));
        List<Derivative> list2 = list.map(new List.Map<Transaction, Derivative>(){

            @Override
            public Derivative map(Transaction transaction) {
                return transaction.deriv;
            }
        });
        List<Derivative> list3 = DerivativesFinder.findDerivativesForSaleByOthers(store.stores, this.pTrans.player.id);
        List<Derivative> list4 = DerivativesFinder.findUniqueDerivatives(list3);
        List<Derivative> list5 = list4.map(new List.Map<Derivative, Derivative>(){

            @Override
            public Derivative map(Derivative derivative) {
                double d2 = derivative.price.val - d;
                return derivative.reoffer(RuleChecker.this.pTrans.player.id, new Price(d2 > 0.0 ? d2 : 0.0));
            }
        });
        if (list2.length() < list5.length()) {
            this.addMessage("Incorrect reoffering - too few Derivatives.");
            return false;
        }
        for (Derivative derivative : list5) {
            if (list2.contains(new CheaperDerivative(derivative))) continue;
            this.addMessage("Incorrect reoffering - price too high");
            return false;
        }
        return true;
    }

    protected boolean correctBuy(Store store) {
        List<Derivative> list = DerivativesFinder.findDerivativesForSale(store.stores);
        List<Transaction> list2 = this.pTrans.transactions.filter(new TransactionComparatorByTType((TransactionType)new Buy()));
        for (Transaction transaction : list2) {
            if (!list.contains(new SameDerivative(transaction.deriv))) {
                this.addMessage("Non-existant derivative bought");
                return false;
            }
            if (!transaction.deriv.seller.equals((Object)this.pTrans.player.id)) continue;
            this.addMessage("Player bought from itself :: " + transaction.deriv.print());
            return false;
        }
        return true;
    }

    protected boolean emptyStoreBuyReoffer(Store store) {
        if (store.stores.isEmpty() || DerivativesFinder.findDerivativesForSaleByOthers(store.stores, this.pTrans.player.id).isEmpty()) {
            for (Transaction transaction : this.pTrans.transactions) {
                if (!transaction.ttype.getClass().equals(Buy.class) && !transaction.ttype.getClass().equals(Reoffer.class)) continue;
                this.addMessage("Buy/Reoffer from an empty store");
                return false;
            }
        }
        return true;
    }

    protected boolean isCreateRuleFollowed(Store store, Game.GameType gameType) {
        if (!this.pTrans.transactions.contains(new TransactionComparatorByTType((TransactionType)new Create()))) {
            this.addMessage("Player did not create a derivative");
            return false;
        }
        List<Transaction> list = this.pTrans.transactions.filter(new TransactionComparatorByTType((TransactionType)new Create()));
        if (list.length() > this.config.MaxCreates) {
            this.addMessage("Created too many derivative");
            return false;
        }
        for (Transaction transaction : list) {
            List<Derivative> list2 = DerivativesFinder.findDerivativesForSale(store.stores);
            if (list2.contains(new SameDerivativeByType(transaction.deriv))) {
                this.addMessage("Created a derivative of an existing type");
                return false;
            }
            if (transaction.deriv.price.val > 1.0 || transaction.deriv.price.val < 0.0) {
                this.addMessage("Illegally priced derivative");
                return false;
            }
            if (gameType.compareTo(Game.GameType.BASEBALL) == 0) continue;
            if (gameType.compareTo(Game.GameType.FASTPITCH2) == 0) {
                if (transaction.deriv.type.instances.length() <= 2) continue;
                this.addMessage("Violated Fastpitch Level 2 Independent creation rule.");
                return false;
            }
            if (gameType.compareTo(Game.GameType.FASTPITCH) == 0) continue;
            if (gameType.compareTo(Game.GameType.SLOWPITCH) == 0) {
                return this.implicationChain(transaction.deriv.type);
            }
            if (gameType.compareTo(Game.GameType.TBALL) != 0 || transaction.deriv.type.instances.length() <= 1) continue;
            this.addMessage("Violated T-Ball creation rule.");
            return false;
        }
        return true;
    }

    protected boolean implicationChain(Type type) {
        TypeInstance typeInstance = null;
        List<TypeInstance> list = type.instances.sort(new TypeInstanceComparator());
        for (TypeInstance typeInstance2 : list) {
            if (typeInstance != null && !RuleChecker.implies(typeInstance, typeInstance2)) {
                this.addMessage("Violated Slowpitch creation rule.");
                return false;
            }
            typeInstance = typeInstance2;
        }
        return true;
    }

    protected static boolean implies(TypeInstance typeInstance, TypeInstance typeInstance2) {
        return (typeInstance.r.v & typeInstance2.r.v) == typeInstance.r.v;
    }

    protected boolean isDeliveryRuleFollowed(Store store) {
        List<Derivative> list;
        List<Transaction> list2 = this.pTrans.transactions.filter(new TransactionComparatorByTType((TransactionType)new Deliver()));
        List<Derivative> list3 = list2.map(new List.Map<Transaction, Derivative>(){

            @Override
            public Derivative map(Transaction transaction) {
                return transaction.deriv;
            }
        });
        if (!list3.same(list = DerivativesFinder.findDersThatNeedRM(store.stores, this.pTrans.player), new DerivativeComp())) {
            this.addMessage("Incorrect number of delivered Derivatives");
            return false;
        }
        for (Derivative derivative : list3) {
            if (this.validRawMaterial(derivative)) continue;
            return false;
        }
        return true;
    }

    protected boolean validRawMaterial(Derivative derivative) {
        if (!derivative.optraw.isSome()) {
            this.addMessage("No RawMaterial found in delivered Derivative");
            return false;
        }
        for (Constraint constraint : ((RawMaterial)derivative.optraw.inner()).instance.cs) {
            if (!derivative.type.instances.contains(new TypeInstance(constraint.r))) {
                this.addMessage("RawMaterial with Type not specified in Derivative found");
                return false;
            }
            List<Variable> list = constraint.vs;
            if (list.length() != 3) {
                this.addMessage("Constraint with too few Variables found");
                return false;
            }
            while (list.length() > 0) {
                Variable variable = (Variable)list.top();
                if (!(list = list.pop()).contains(variable)) continue;
                this.addMessage("Duplicate Variable found in Constraint: " + constraint.print() + "");
                return false;
            }
        }
        return true;
    }

    protected boolean isFinishRuleFollowed(Store store) {
        List<Transaction> list = this.pTrans.transactions.filter(new TransactionComparatorByTType((TransactionType)new Finish()));
        List<Object> list2 = List.create(new Object[0]);
        for (Transaction object : list) {
            list2 = list2.push(object.deriv);
        }
        List<Derivative> list3 = DerivativesFinder.findDersThatNeedFinishing(store.stores, this.pTrans.player);
        if (!list2.same((List<Object>)list3, new DerivativeComp())) {
            this.addMessage("Incorrect number of finished derivatives");
            return false;
        }
        for (Derivative derivative : list2) {
            Assignment assignment = ((FinishedProduct)derivative.optfinished.inner()).ip.assignment;
            RawMaterial rawMaterial = (RawMaterial)derivative.optraw.inner();
            if (SufficientAssignment.good(rawMaterial, assignment)) continue;
            this.addMessage("Insufficient assignment");
            return false;
        }
        return true;
    }
}

