/*
 * Decompiled with CFR 0.152.
 */
package admin.utils;

import config.AdminConfig;
import config.GlobalConfig;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import gen.Accounts;
import gen.Config;
import gen.History;
import gen.Pair;
import gen.Player;
import gen.PlayerID;
import gen.PlayerTransaction;
import gen.Players;
import gen.Round;
import gen.Store;
import utils.DocumentHandler;

public class AdminDocumentHandler
extends DocumentHandler {
    public static void resetFilesToDefault() {
        final Config config = AdminDocumentHandler.getConfig();
        AdminDocumentHandler.write("history[ ", "blackboard" + GlobalConfig.SEPAR + "history.input");
        AdminDocumentHandler.commitStore(new Store(List.create(new Pair[0])));
        AdminDocumentHandler.commitAccounts(new Accounts(AdminDocumentHandler.getPlayers().players.map(new List.Map<Player, Pair<PlayerID, Double>>(){

            @Override
            public Pair<PlayerID, Double> map(Player player) {
                return new Pair((Object)player.id, (Object)config.Money);
            }
        })));
    }

    public static void commitHistory(History history) {
        String string = "history.input";
        AdminDocumentHandler.write(history.printIter(), "blackboard" + GlobalConfig.SEPAR + string);
    }

    public static void updateHistory(Round round) {
        String string = "history.input";
        AdminDocumentHandler.write(round.print(), "blackboard" + GlobalConfig.SEPAR + string, true);
    }

    public static void closeHistory() {
        String string = "history.input";
        AdminDocumentHandler.write("]", "blackboard" + GlobalConfig.SEPAR + string, true);
    }

    public static void commitAccounts(Accounts accounts) {
        String string = "accounts.input";
        AdminDocumentHandler.write(accounts.print(), "blackboard" + GlobalConfig.SEPAR + string);
    }

    public static void commitStore(Store store) {
        String string = "store.input";
        AdminDocumentHandler.write(store.print(), "blackboard" + GlobalConfig.SEPAR + string);
    }

    public static Accounts getAccounts() {
        return DocumentHandler.getAccounts("blackboard");
    }

    public static Store getStore() {
        return DocumentHandler.getStore("blackboard");
    }

    public static History getHistory() {
        return DocumentHandler.getHistory("blackboard");
    }

    public static PlayerTransaction getPlayerTrans(Player player) {
        return DocumentHandler.getPlayerTrans(player, "blackboard");
    }

    public static void deletePlayerTrans(Player player) {
        DocumentHandler.deletePlayerTrans(player, "blackboard");
    }

    public static Players getPlayers() {
        return DocumentHandler.getPlayers(AdminConfig.BLACKBOARD_ADMIN_PATH);
    }

    public static Config getConfig() {
        return DocumentHandler.getConfig(AdminConfig.BLACKBOARD_ADMIN_PATH);
    }
}

