/*
 * Decompiled with CFR 0.152.
 */
package gen;

import edu.neu.ccs.demeterf.control.Fields;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import gen.Display;
import gen.Pair;
import gen.ParseException;
import gen.Player;
import gen.PlayerID;
import gen.PlayerStore;
import gen.PrintHeap;
import gen.PrintHeapToString;
import gen.TheParser;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Store {
    public List<Pair<PlayerID, PlayerStore>> stores;

    public Store(List<Pair<PlayerID, PlayerStore>> list) {
        this.stores = list;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Store)) {
            return false;
        }
        Store store = (Store)object;
        return this.stores.equals(store.stores);
    }

    public static Store parse(String string) throws ParseException {
        return new TheParser(new StringReader(string)).parse_Store();
    }

    public static Store parse(InputStream inputStream) throws ParseException {
        return new TheParser(inputStream).parse_Store();
    }

    public static Store parse(Reader reader) throws ParseException {
        return new TheParser(reader).parse_Store();
    }

    public String printIter() {
        String string = "store[";
        for (Pair pair : this.stores) {
            string = string + ((PlayerID)pair.a).print() + " " + ((PlayerStore)pair.b).printIter();
        }
        string = string + "]";
        return string;
    }

    public boolean contains(PlayerID playerID) {
        return this.stores.contains((List.Pred)new StorePred(playerID));
    }

    public PlayerStore getStore(Player player2) {
        return this.getStore(player2.id);
    }

    public PlayerStore getStore(PlayerID playerID) {
        return (PlayerStore)this.getStorePair((PlayerID)playerID).b;
    }

    public Pair<PlayerID, PlayerStore> getStorePair(PlayerID playerID) {
        return (Pair)this.stores.find((List.Pred)new StorePred(playerID));
    }

    public Store add(Pair<PlayerID, PlayerStore> pair) {
        return new Store((List<Pair<PlayerID, PlayerStore>>)this.stores.push(pair));
    }

    public Store replace(Pair<PlayerID, PlayerStore> pair) {
        return new Store((List<Pair<PlayerID, PlayerStore>>)this.stores.replace((List.Pred)new StorePred((PlayerID)pair.a), pair));
    }

    public Store remove(PlayerID playerID) {
        return new Store((List<Pair<PlayerID, PlayerStore>>)this.stores.remove((List.Pred)new StorePred(playerID)));
    }

    public String display() {
        return Display.DisplayM(this);
    }

    public String print() {
        return PrintHeap.PrintHeapM(this);
    }

    public String toString() {
        return PrintHeapToString.PrintHeapToStringM(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StorePred
    extends List.Pred<Pair<PlayerID, PlayerStore>> {
        PlayerID pid;

        StorePred(PlayerID playerID) {
            this.pid = playerID;
        }

        public boolean huh(Pair<PlayerID, PlayerStore> pair) {
            return ((PlayerID)pair.a).equals(this.pid);
        }
    }

    public static class stores
    extends Fields.any {
    }
}

