/*
 * Decompiled with CFR 0.152.
 */
package player;

import edu.neu.ccs.demeterf.demfgen.lib.List;
import gen.Buy;
import gen.Create;
import gen.Deliver;
import gen.Derivative;
import gen.Finish;
import gen.Player;
import gen.PlayerID;
import gen.PlayerTransaction;
import gen.Reoffer;
import gen.Transaction;
import gen.TransactionType;
import player.PlayerI;
import player.Util;
import player.playeragent.ReofferAgent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerRunner {
    private Player player;
    private PlayerI genericPlayer;

    public PlayerRunner(String string, PlayerI playerI) {
        this.genericPlayer = playerI;
        this.player = new Player(new PlayerID(Integer.parseInt(string)), playerI.getName());
    }

    public void main() {
        List<List<List<List<Transaction>>>> list = this.buyOrReofferDerivative().append((Transaction)this.createDerivative().append((Transaction)this.deliverRawMaterial().append((Transaction)this.finishProduct())));
        Util.commitTransaction(new PlayerTransaction(this.player, list));
    }

    public ReofferAgent getReofferAgent() {
        return new ReofferAgent();
    }

    private List<Transaction> createDerivative() {
        Derivative derivative = this.genericPlayer.getCreateAgent().createDerivative(this.player, Util.existingTypes());
        return List.create(new Transaction((TransactionType)new Create(), derivative));
    }

    private List<Transaction> buyOrReofferDerivative() {
        List<Derivative> list = Util.forSale(this.player.id);
        if (list.isEmpty()) {
            return List.create(new Object[0]);
        }
        double d = Util.getAccount(this.player);
        List<Derivative> list2 = this.genericPlayer.getBuyAgent().buyDerivatives(list, d);
        if (!list2.isEmpty()) {
            return list2.map(new TransWrap((TransactionType)new Buy()));
        }
        return this.reofferAll(list, this.player.id);
    }

    private List<Transaction> reofferAll(List<Derivative> list, PlayerID playerID) {
        return Util.uniquelyTyped(list).map(new PriceReducer(this.getReofferAgent(), playerID));
    }

    private List<Transaction> deliverRawMaterial() {
        List<Derivative> list = Util.needRawMaterial(this.player);
        return list.map(new Deliverer(this.genericPlayer.getDeliverAgent()));
    }

    private List<Transaction> finishProduct() {
        List<Derivative> list = Util.toBeFinished(this.player);
        return list.map(new Finisher(this.genericPlayer.getFinishAgent()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Finisher
    extends List.Map<Derivative, Transaction> {
        PlayerI.FinishAgentI agent;

        Finisher(PlayerI.FinishAgentI finishAgentI) {
            this.agent = finishAgentI;
        }

        @Override
        public Transaction map(Derivative derivative) {
            return new Transaction((TransactionType)new Finish(), derivative.finish(this.agent.finishDerivative(derivative)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Deliverer
    extends List.Map<Derivative, Transaction> {
        PlayerI.DeliverAgentI agent;

        Deliverer(PlayerI.DeliverAgentI deliverAgentI) {
            this.agent = deliverAgentI;
        }

        @Override
        public Transaction map(Derivative derivative) {
            return new Transaction((TransactionType)new Deliver(), this.agent.deliverRawMaterial(derivative));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PriceReducer
    extends List.Map<Derivative, Transaction> {
        ReofferAgent agent;
        PlayerID pid;

        PriceReducer(ReofferAgent reofferAgent, PlayerID playerID) {
            this.pid = playerID;
            this.agent = reofferAgent;
        }

        @Override
        public Transaction map(Derivative derivative) {
            return new Transaction((TransactionType)new Reoffer(), this.agent.reofferDerivative(derivative, this.pid));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransWrap
    extends List.Map<Derivative, Transaction> {
        private TransactionType type;

        public TransWrap(TransactionType transactionType) {
            this.type = transactionType;
        }

        @Override
        public Transaction map(Derivative derivative) {
            return new Transaction(this.type, derivative);
        }
    }
}

