package player.playeragent;

import static org.junit.Assert.*;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.demfgen.lib.Option;
import edu.neu.ccs.demeterf.demfgen.lib.ident;
import gen.*;

import org.junit.Before;
import org.junit.Test;

public class FinishAgentTest {

	private FinishAgent finishAgent;
	private Variable a, b, c, d;
	private Literal aPos, bPos, cPos, aNeg, bNeg, cNeg, dPos;
	private List<Variable> abc, bcd, acd;
	private List<Literal> abcPos, abcNeg;
	
	@Before
	public void setUp() {
		finishAgent = new FinishAgent();
		a = new Variable(new ident("a"));
		b = new Variable(new ident("b"));
		c = new Variable(new ident("c"));
		d = new Variable(new ident("d"));
		//e = new Variable(new ident("e"));
    	
		abc = List.<Variable>create(a, b, c);
		bcd = List.<Variable>create(b, c, d);
		acd = List.<Variable>create(a, c, d);
		
    	aPos = new Literal(new Pos(), a);
    	bPos = new Literal(new Pos(), b);
    	cPos = new Literal(new Pos(), c);
    	aNeg = new Literal(new Neg(), a);
    	bNeg = new Literal(new Neg(), b);
    	cNeg = new Literal(new Neg(), c);
    	dPos = new Literal(new Pos(), d);
    	
    	abcPos = List.<Literal>create(aPos, bPos, cPos);
    	abcNeg = List.<Literal>create(aNeg, bNeg, cNeg);
	}
	
	@Test
	public void testGetQualityMax() {
    	int relationNum = 6;
    	
		List<TypeInstance> typeInst = List.<TypeInstance>create(new TypeInstance(new RelationNr(relationNum)));
		RawMaterialInstance rmi = new RawMaterialInstance(List.<Constraint>create(new Constraint(
				new Weight(1), new RelationNr(relationNum), abc)));
		
    	Derivative d1 = new Derivative("D1", new PlayerID(0), Option.some(new PlayerID(1)), new Price(.3),
    			new Type(typeInst), Option.some(new RawMaterial(rmi)), Option.<FinishedProduct>none());

    	Assignment assign = new Assignment(List.create(aPos, bNeg, cNeg));
    	
		assertEquals(1.0, finishAgent.getQuality(d1, assign), 0.0000001);
	}
	
	@Test
	public void testGetQualitySome() {
		int relationNum = 22;
		
		List<TypeInstance> typeInst = List.<TypeInstance>create(new TypeInstance(new RelationNr(relationNum)));
		RawMaterialInstance rmi = new RawMaterialInstance(List.<Constraint>create(
				new Constraint(new Weight(1), new RelationNr(relationNum), abc),
				new Constraint(new Weight(1), new RelationNr(relationNum), bcd),
				new Constraint(new Weight(1), new RelationNr(relationNum), acd)));
		
    	Derivative d1 = new Derivative("D1", new PlayerID(0), Option.some(new PlayerID(1)), new Price(.3),
    			new Type(typeInst), Option.some(new RawMaterial(rmi)), Option.<FinishedProduct>none());

    	Assignment assign = new Assignment(List.create(aPos, bNeg, cNeg, dPos));
    	
		assertEquals(0.666666666666, finishAgent.getQuality(d1, assign), 0.0000001);
	}
	
	@Test
	public void testGetQualityNone() {
		int relationNum = 8;
		
		List<TypeInstance> typeInst = List.<TypeInstance>create(new TypeInstance(new RelationNr(relationNum)));
		RawMaterialInstance rmi = new RawMaterialInstance(List.<Constraint>create(
				new Constraint(new Weight(1), new RelationNr(relationNum), abc),
				new Constraint(new Weight(1), new RelationNr(relationNum), bcd)));
		
    	Derivative d1 = new Derivative("D1", new PlayerID(0), Option.some(new PlayerID(1)), new Price(.3),
    			new Type(typeInst), Option.some(new RawMaterial(rmi)), Option.<FinishedProduct>none());

    	Assignment assign = new Assignment(List.create(aPos, bNeg, cNeg, dPos));
    	
		assertEquals(0.0, finishAgent.getQuality(d1, assign), 0.0000001);
	}
	
	
	@Test
	public void testGenerateAssignmentPos() {
		Assignment expected = new Assignment(abcPos);
		Assignment actual = finishAgent.generateAssignment(abc, 1);
		
		assertEquals(expected, actual);
	}
	
	@Test
	public void testGenerateAssignmentNeg() {
		Assignment expected = new Assignment(abcNeg);
		Assignment actual = finishAgent.generateAssignment(abc, 0);
		
		assertEquals(expected, actual);
	}
	
	
	@Test
	public void testFinishDerivativeR1() {
		int relationNum = 1;
		testFinishDerivative(relationNum, 1);
	}
	
	@Test
	public void testFinishDerivativeR128() {
		int relationNum = 128;
		testFinishDerivative(relationNum, 1);
	}
	
	private void testFinishDerivative(int relationNum, double expectedQuality) {
		List<TypeInstance> typeInst = List.<TypeInstance>create(new TypeInstance(new RelationNr(relationNum)));
		RawMaterialInstance rmi = new RawMaterialInstance(List.<Constraint>create(
				new Constraint(new Weight(1), new RelationNr(relationNum), abc),
				new Constraint(new Weight(1), new RelationNr(relationNum), bcd)));
		
    	Derivative d1 = new Derivative("D1", new PlayerID(0), Option.some(new PlayerID(1)), new Price(.3),
    			new Type(typeInst), Option.some(new RawMaterial(rmi)), Option.<FinishedProduct>none());
    	
    	double actualQuality = finishAgent.finishDerivative(d1).quality.val;
    	assertEquals(expectedQuality, actualQuality);
	}
}

